package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoTune(
    autoTuneType: Option[zio.aws.elasticsearch.model.AutoTuneType] = None,
    autoTuneDetails: Option[zio.aws.elasticsearch.model.AutoTuneDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTune = {
    import AutoTune.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTune
      .builder()
      .optionallyWith(autoTuneType.map(value => value.unwrap))(_.autoTuneType)
      .optionallyWith(autoTuneDetails.map(value => value.buildAwsValue()))(
        _.autoTuneDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTune.ReadOnly =
    zio.aws.elasticsearch.model.AutoTune.wrap(buildAwsValue())
}
object AutoTune {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTune =
      zio.aws.elasticsearch.model.AutoTune(
        autoTuneType.map(value => value),
        autoTuneDetails.map(value => value.asEditable)
      )
    def autoTuneType: Option[zio.aws.elasticsearch.model.AutoTuneType]
    def autoTuneDetails
        : Option[zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly]
    def getAutoTuneType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneType] =
      AwsError.unwrapOptionField("autoTuneType", autoTuneType)
    def getAutoTuneDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneDetails", autoTuneDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ) extends zio.aws.elasticsearch.model.AutoTune.ReadOnly {
    override val autoTuneType
        : Option[zio.aws.elasticsearch.model.AutoTuneType] = scala
      .Option(impl.autoTuneType())
      .map(value => zio.aws.elasticsearch.model.AutoTuneType.wrap(value))
    override val autoTuneDetails
        : Option[zio.aws.elasticsearch.model.AutoTuneDetails.ReadOnly] = scala
      .Option(impl.autoTuneDetails())
      .map(value => zio.aws.elasticsearch.model.AutoTuneDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTune
  ): zio.aws.elasticsearch.model.AutoTune.ReadOnly = new Wrapper(impl)
}
