package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetUpgradeStatusRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest = {
    import GetUpgradeStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.GetUpgradeStatusRequest.ReadOnly =
    zio.aws.elasticsearch.model.GetUpgradeStatusRequest.wrap(buildAwsValue())
}
object GetUpgradeStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.GetUpgradeStatusRequest =
      zio.aws.elasticsearch.model.GetUpgradeStatusRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest
  ) extends zio.aws.elasticsearch.model.GetUpgradeStatusRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest
  ): zio.aws.elasticsearch.model.GetUpgradeStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
