package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{ErrorMessage, ErrorType}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ErrorDetails(
    errorType: Option[ErrorType] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ErrorDetails = {
    import ErrorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ErrorDetails
      .builder()
      .optionallyWith(
        errorType.map(value => ErrorType.unwrap(value): java.lang.String)
      )(_.errorType)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ErrorDetails.ReadOnly =
    zio.aws.elasticsearch.model.ErrorDetails.wrap(buildAwsValue())
}
object ErrorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ErrorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ErrorDetails =
      zio.aws.elasticsearch.model.ErrorDetails(
        errorType.map(value => value),
        errorMessage.map(value => value)
      )
    def errorType: Option[ErrorType]
    def errorMessage: Option[ErrorMessage]
    def getErrorType: ZIO[Any, AwsError, ErrorType] =
      AwsError.unwrapOptionField("errorType", errorType)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ErrorDetails
  ) extends zio.aws.elasticsearch.model.ErrorDetails.ReadOnly {
    override val errorType: Option[ErrorType] = scala
      .Option(impl.errorType())
      .map(value => zio.aws.elasticsearch.model.primitives.ErrorType(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.elasticsearch.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ErrorDetails
  ): zio.aws.elasticsearch.model.ErrorDetails.ReadOnly = new Wrapper(impl)
}
