package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeletePackageResponse(
    packageDetails: Option[zio.aws.elasticsearch.model.PackageDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse = {
    import DeletePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.DeletePackageResponse.wrap(buildAwsValue())
}
object DeletePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DeletePackageResponse =
      zio.aws.elasticsearch.model
        .DeletePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Option[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]
    def getPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse
  ) extends zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly {
    override val packageDetails
        : Option[zio.aws.elasticsearch.model.PackageDetails.ReadOnly] = scala
      .Option(impl.packageDetails())
      .map(value => zio.aws.elasticsearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeletePackageResponse
  ): zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
