package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePackageResponse(
    packageDetails: Option[zio.aws.elasticsearch.model.PackageDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse = {
    import CreatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.CreatePackageResponse.wrap(buildAwsValue())
}
object CreatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CreatePackageResponse =
      zio.aws.elasticsearch.model
        .CreatePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Option[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]
    def getPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse
  ) extends zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly {
    override val packageDetails
        : Option[zio.aws.elasticsearch.model.PackageDetails.ReadOnly] = scala
      .Option(impl.packageDetails())
      .map(value => zio.aws.elasticsearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreatePackageResponse
  ): zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
