package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  LastUpdated,
  Description,
  ChangeProgressStageStatus,
  ChangeProgressStageName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ChangeProgressStage(
    name: Option[ChangeProgressStageName] = None,
    status: Option[ChangeProgressStageStatus] = None,
    description: Option[Description] = None,
    lastUpdated: Option[LastUpdated] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage = {
    import ChangeProgressStage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage
      .builder()
      .optionallyWith(
        name.map(value =>
          ChangeProgressStageName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        status.map(value =>
          ChangeProgressStageStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        lastUpdated.map(value => LastUpdated.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly =
    zio.aws.elasticsearch.model.ChangeProgressStage.wrap(buildAwsValue())
}
object ChangeProgressStage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ChangeProgressStage =
      zio.aws.elasticsearch.model.ChangeProgressStage(
        name.map(value => value),
        status.map(value => value),
        description.map(value => value),
        lastUpdated.map(value => value)
      )
    def name: Option[ChangeProgressStageName]
    def status: Option[ChangeProgressStageStatus]
    def description: Option[Description]
    def lastUpdated: Option[LastUpdated]
    def getName: ZIO[Any, AwsError, ChangeProgressStageName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, ChangeProgressStageStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastUpdated: ZIO[Any, AwsError, LastUpdated] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage
  ) extends zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly {
    override val name: Option[ChangeProgressStageName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ChangeProgressStageName(value)
      )
    override val status: Option[ChangeProgressStageStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ChangeProgressStageStatus(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.elasticsearch.model.primitives.Description(value))
    override val lastUpdated: Option[LastUpdated] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.elasticsearch.model.primitives.LastUpdated(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage
  ): zio.aws.elasticsearch.model.ChangeProgressStage.ReadOnly = new Wrapper(
    impl
  )
}
