package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{
  IntegerClass,
  BackendRole,
  Username
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SAMLOptionsInput(
    enabled: Option[Boolean] = None,
    idp: Option[zio.aws.elasticsearch.model.SAMLIdp] = None,
    masterUserName: Option[Username] = None,
    masterBackendRole: Option[BackendRole] = None,
    subjectKey: Option[String] = None,
    rolesKey: Option[String] = None,
    sessionTimeoutMinutes: Option[IntegerClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput = {
    import SAMLOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(idp.map(value => value.buildAwsValue()))(_.idp)
      .optionallyWith(
        masterUserName.map(value => Username.unwrap(value): java.lang.String)
      )(_.masterUserName)
      .optionallyWith(
        masterBackendRole.map(value =>
          BackendRole.unwrap(value): java.lang.String
        )
      )(_.masterBackendRole)
      .optionallyWith(subjectKey.map(value => value: java.lang.String))(
        _.subjectKey
      )
      .optionallyWith(rolesKey.map(value => value: java.lang.String))(
        _.rolesKey
      )
      .optionallyWith(
        sessionTimeoutMinutes.map(value => IntegerClass.unwrap(value): Integer)
      )(_.sessionTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly =
    zio.aws.elasticsearch.model.SAMLOptionsInput.wrap(buildAwsValue())
}
object SAMLOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SAMLOptionsInput =
      zio.aws.elasticsearch.model.SAMLOptionsInput(
        enabled.map(value => value),
        idp.map(value => value.asEditable),
        masterUserName.map(value => value),
        masterBackendRole.map(value => value),
        subjectKey.map(value => value),
        rolesKey.map(value => value),
        sessionTimeoutMinutes.map(value => value)
      )
    def enabled: Option[Boolean]
    def idp: Option[zio.aws.elasticsearch.model.SAMLIdp.ReadOnly]
    def masterUserName: Option[Username]
    def masterBackendRole: Option[BackendRole]
    def subjectKey: Option[String]
    def rolesKey: Option[String]
    def sessionTimeoutMinutes: Option[IntegerClass]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIdp
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.SAMLIdp.ReadOnly] =
      AwsError.unwrapOptionField("idp", idp)
    def getMasterUserName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("masterUserName", masterUserName)
    def getMasterBackendRole: ZIO[Any, AwsError, BackendRole] =
      AwsError.unwrapOptionField("masterBackendRole", masterBackendRole)
    def getSubjectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subjectKey", subjectKey)
    def getRolesKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rolesKey", rolesKey)
    def getSessionTimeoutMinutes: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("sessionTimeoutMinutes", sessionTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput
  ) extends zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val idp: Option[zio.aws.elasticsearch.model.SAMLIdp.ReadOnly] =
      scala
        .Option(impl.idp())
        .map(value => zio.aws.elasticsearch.model.SAMLIdp.wrap(value))
    override val masterUserName: Option[Username] = scala
      .Option(impl.masterUserName())
      .map(value => zio.aws.elasticsearch.model.primitives.Username(value))
    override val masterBackendRole: Option[BackendRole] = scala
      .Option(impl.masterBackendRole())
      .map(value => zio.aws.elasticsearch.model.primitives.BackendRole(value))
    override val subjectKey: Option[String] =
      scala.Option(impl.subjectKey()).map(value => value: String)
    override val rolesKey: Option[String] =
      scala.Option(impl.rolesKey()).map(value => value: String)
    override val sessionTimeoutMinutes: Option[IntegerClass] = scala
      .Option(impl.sessionTimeoutMinutes())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsInput
  ): zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly = new Wrapper(impl)
}
