package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  MaxResults,
  DomainName,
  ElasticsearchVersionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListElasticsearchInstanceTypesRequest(
    elasticsearchVersion: ElasticsearchVersionString,
    domainName: Option[DomainName] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest = {
    import ListElasticsearchInstanceTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
      .builder()
      .elasticsearchVersion(
        ElasticsearchVersionString.unwrap(
          elasticsearchVersion
        ): java.lang.String
      )
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest
      .wrap(buildAwsValue())
}
object ListElasticsearchInstanceTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest =
      zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest(
        elasticsearchVersion,
        domainName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def elasticsearchVersion: ElasticsearchVersionString
    def domainName: Option[DomainName]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getElasticsearchVersion: ZIO[Any, Nothing, ElasticsearchVersionString] =
      ZIO.succeed(elasticsearchVersion)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ) extends zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly {
    override val elasticsearchVersion: ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives
        .ElasticsearchVersionString(impl.elasticsearchVersion())
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest
  ): zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesRequest.ReadOnly =
    new Wrapper(impl)
}
