package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{LimitValue, LimitName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AdditionalLimit(
    limitName: Option[LimitName] = None,
    limitValues: Option[Iterable[LimitValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit = {
    import AdditionalLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit
      .builder()
      .optionallyWith(
        limitName.map(value => LimitName.unwrap(value): java.lang.String)
      )(_.limitName)
      .optionallyWith(
        limitValues.map(value =>
          value.map { item =>
            LimitValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.limitValues)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly =
    zio.aws.elasticsearch.model.AdditionalLimit.wrap(buildAwsValue())
}
object AdditionalLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdditionalLimit =
      zio.aws.elasticsearch.model.AdditionalLimit(
        limitName.map(value => value),
        limitValues.map(value => value)
      )
    def limitName: Option[LimitName]
    def limitValues: Option[List[LimitValue]]
    def getLimitName: ZIO[Any, AwsError, LimitName] =
      AwsError.unwrapOptionField("limitName", limitName)
    def getLimitValues: ZIO[Any, AwsError, List[LimitValue]] =
      AwsError.unwrapOptionField("limitValues", limitValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit
  ) extends zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly {
    override val limitName: Option[LimitName] = scala
      .Option(impl.limitName())
      .map(value => zio.aws.elasticsearch.model.primitives.LimitName(value))
    override val limitValues: Option[List[LimitValue]] = scala
      .Option(impl.limitValues())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives.LimitValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdditionalLimit
  ): zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly = new Wrapper(impl)
}
