package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.IntegerClass
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EBSOptions(
    ebsEnabled: Option[Boolean] = None,
    volumeType: Option[zio.aws.elasticsearch.model.VolumeType] = None,
    volumeSize: Option[IntegerClass] = None,
    iops: Option[IntegerClass] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.EBSOptions = {
    import EBSOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.EBSOptions
      .builder()
      .optionallyWith(ebsEnabled.map(value => value: java.lang.Boolean))(
        _.ebsEnabled
      )
      .optionallyWith(volumeType.map(value => value.unwrap))(_.volumeType)
      .optionallyWith(
        volumeSize.map(value => IntegerClass.unwrap(value): Integer)
      )(_.volumeSize)
      .optionallyWith(iops.map(value => IntegerClass.unwrap(value): Integer))(
        _.iops
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.EBSOptions.ReadOnly =
    zio.aws.elasticsearch.model.EBSOptions.wrap(buildAwsValue())
}
object EBSOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.EBSOptions =
      zio.aws.elasticsearch.model.EBSOptions(
        ebsEnabled.map(value => value),
        volumeType.map(value => value),
        volumeSize.map(value => value),
        iops.map(value => value)
      )
    def ebsEnabled: Option[Boolean]
    def volumeType: Option[zio.aws.elasticsearch.model.VolumeType]
    def volumeSize: Option[IntegerClass]
    def iops: Option[IntegerClass]
    def getEbsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsEnabled", ebsEnabled)
    def getVolumeType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VolumeType] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getVolumeSize: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getIops: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ) extends zio.aws.elasticsearch.model.EBSOptions.ReadOnly {
    override val ebsEnabled: Option[Boolean] =
      scala.Option(impl.ebsEnabled()).map(value => value: Boolean)
    override val volumeType: Option[zio.aws.elasticsearch.model.VolumeType] =
      scala
        .Option(impl.volumeType())
        .map(value => zio.aws.elasticsearch.model.VolumeType.wrap(value))
    override val volumeSize: Option[IntegerClass] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val iops: Option[IntegerClass] = scala
      .Option(impl.iops())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptions
  ): zio.aws.elasticsearch.model.EBSOptions.ReadOnly = new Wrapper(impl)
}
