package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteInboundCrossClusterSearchConnectionResponse(
    crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse = {
    import DeleteInboundCrossClusterSearchConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnection.map(value => value.buildAwsValue())
      )(_.crossClusterSearchConnection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly =
    zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteInboundCrossClusterSearchConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse =
      zio.aws.elasticsearch.model
        .DeleteInboundCrossClusterSearchConnectionResponse(
          crossClusterSearchConnection.map(value => value.asEditable)
        )
    def crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ]
    def getCrossClusterSearchConnection: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossClusterSearchConnection",
      crossClusterSearchConnection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse
  ) extends zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly {
    override val crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = scala
      .Option(impl.crossClusterSearchConnection())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse
  ): zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
