package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.StartAt
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AutoTuneMaintenanceSchedule(
    startAt: Option[StartAt] = None,
    duration: Option[zio.aws.elasticsearch.model.Duration] = None,
    cronExpressionForRecurrence: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule = {
    import AutoTuneMaintenanceSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
      .builder()
      .optionallyWith(startAt.map(value => StartAt.unwrap(value): Instant))(
        _.startAt
      )
      .optionallyWith(duration.map(value => value.buildAwsValue()))(_.duration)
      .optionallyWith(
        cronExpressionForRecurrence.map(value => value: java.lang.String)
      )(_.cronExpressionForRecurrence)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule
      .wrap(buildAwsValue())
}
object AutoTuneMaintenanceSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule =
      zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule(
        startAt.map(value => value),
        duration.map(value => value.asEditable),
        cronExpressionForRecurrence.map(value => value)
      )
    def startAt: Option[StartAt]
    def duration: Option[zio.aws.elasticsearch.model.Duration.ReadOnly]
    def cronExpressionForRecurrence: Option[String]
    def getStartAt: ZIO[Any, AwsError, StartAt] =
      AwsError.unwrapOptionField("startAt", startAt)
    def getDuration
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.Duration.ReadOnly] =
      AwsError.unwrapOptionField("duration", duration)
    def getCronExpressionForRecurrence: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "cronExpressionForRecurrence",
        cronExpressionForRecurrence
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ) extends zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly {
    override val startAt: Option[StartAt] = scala
      .Option(impl.startAt())
      .map(value => zio.aws.elasticsearch.model.primitives.StartAt(value))
    override val duration
        : Option[zio.aws.elasticsearch.model.Duration.ReadOnly] = scala
      .Option(impl.duration())
      .map(value => zio.aws.elasticsearch.model.Duration.wrap(value))
    override val cronExpressionForRecurrence: Option[String] = scala
      .Option(impl.cronExpressionForRecurrence())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ): zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly =
    new Wrapper(impl)
}
