package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateElasticsearchDomainConfigResponse(
    domainConfig: zio.aws.elasticsearch.model.ElasticsearchDomainConfig,
    dryRunResults: Option[zio.aws.elasticsearch.model.DryRunResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse = {
    import UpdateElasticsearchDomainConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse
      .builder()
      .domainConfig(domainConfig.buildAwsValue())
      .optionallyWith(dryRunResults.map(value => value.buildAwsValue()))(
        _.dryRunResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly =
    zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse
      .wrap(buildAwsValue())
}
object UpdateElasticsearchDomainConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse =
      zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse(
        domainConfig.asEditable,
        dryRunResults.map(value => value.asEditable)
      )
    def domainConfig
        : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly
    def dryRunResults
        : Option[zio.aws.elasticsearch.model.DryRunResults.ReadOnly]
    def getDomainConfig: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly
    ] = ZIO.succeed(domainConfig)
    def getDryRunResults: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DryRunResults.ReadOnly
    ] = AwsError.unwrapOptionField("dryRunResults", dryRunResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse
  ) extends zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly {
    override val domainConfig
        : zio.aws.elasticsearch.model.ElasticsearchDomainConfig.ReadOnly =
      zio.aws.elasticsearch.model.ElasticsearchDomainConfig
        .wrap(impl.domainConfig())
    override val dryRunResults
        : Option[zio.aws.elasticsearch.model.DryRunResults.ReadOnly] = scala
      .Option(impl.dryRunResults())
      .map(value => zio.aws.elasticsearch.model.DryRunResults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigResponse
  ): zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly =
    new Wrapper(impl)
}
