package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.UpgradeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetUpgradeStatusResponse(
    upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep] = None,
    stepStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus] = None,
    upgradeName: Option[UpgradeName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse = {
    import GetUpgradeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(
        upgradeName.map(value => UpgradeName.unwrap(value): java.lang.String)
      )(_.upgradeName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly =
    zio.aws.elasticsearch.model.GetUpgradeStatusResponse.wrap(buildAwsValue())
}
object GetUpgradeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.GetUpgradeStatusResponse =
      zio.aws.elasticsearch.model.GetUpgradeStatusResponse(
        upgradeStep.map(value => value),
        stepStatus.map(value => value),
        upgradeName.map(value => value)
      )
    def upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep]
    def stepStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus]
    def upgradeName: Option[UpgradeName]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getStepStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getUpgradeName: ZIO[Any, AwsError, UpgradeName] =
      AwsError.unwrapOptionField("upgradeName", upgradeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ) extends zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly {
    override val upgradeStep: Option[zio.aws.elasticsearch.model.UpgradeStep] =
      scala
        .Option(impl.upgradeStep())
        .map(value => zio.aws.elasticsearch.model.UpgradeStep.wrap(value))
    override val stepStatus: Option[zio.aws.elasticsearch.model.UpgradeStatus] =
      scala
        .Option(impl.stepStatus())
        .map(value => zio.aws.elasticsearch.model.UpgradeStatus.wrap(value))
    override val upgradeName: Option[UpgradeName] = scala
      .Option(impl.upgradeName())
      .map(value => zio.aws.elasticsearch.model.primitives.UpgradeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ): zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly =
    new Wrapper(impl)
}
