package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.IntegerClass
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ElasticsearchClusterConfig(
    instanceType: Option[zio.aws.elasticsearch.model.ESPartitionInstanceType] =
      None,
    instanceCount: Option[IntegerClass] = None,
    dedicatedMasterEnabled: Option[Boolean] = None,
    zoneAwarenessEnabled: Option[Boolean] = None,
    zoneAwarenessConfig: Option[
      zio.aws.elasticsearch.model.ZoneAwarenessConfig
    ] = None,
    dedicatedMasterType: Option[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = None,
    dedicatedMasterCount: Option[IntegerClass] = None,
    warmEnabled: Option[Boolean] = None,
    warmType: Option[zio.aws.elasticsearch.model.ESWarmPartitionInstanceType] =
      None,
    warmCount: Option[IntegerClass] = None,
    coldStorageOptions: Option[zio.aws.elasticsearch.model.ColdStorageOptions] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig = {
    import ElasticsearchClusterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
      .builder()
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        instanceCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.instanceCount)
      .optionallyWith(
        dedicatedMasterEnabled.map(value => value: java.lang.Boolean)
      )(_.dedicatedMasterEnabled)
      .optionallyWith(
        zoneAwarenessEnabled.map(value => value: java.lang.Boolean)
      )(_.zoneAwarenessEnabled)
      .optionallyWith(zoneAwarenessConfig.map(value => value.buildAwsValue()))(
        _.zoneAwarenessConfig
      )
      .optionallyWith(dedicatedMasterType.map(value => value.unwrap))(
        _.dedicatedMasterType
      )
      .optionallyWith(
        dedicatedMasterCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.dedicatedMasterCount)
      .optionallyWith(warmEnabled.map(value => value: java.lang.Boolean))(
        _.warmEnabled
      )
      .optionallyWith(warmType.map(value => value.unwrap))(_.warmType)
      .optionallyWith(
        warmCount.map(value => IntegerClass.unwrap(value): Integer)
      )(_.warmCount)
      .optionallyWith(coldStorageOptions.map(value => value.buildAwsValue()))(
        _.coldStorageOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
    zio.aws.elasticsearch.model.ElasticsearchClusterConfig.wrap(buildAwsValue())
}
object ElasticsearchClusterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ElasticsearchClusterConfig =
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig(
        instanceType.map(value => value),
        instanceCount.map(value => value),
        dedicatedMasterEnabled.map(value => value),
        zoneAwarenessEnabled.map(value => value),
        zoneAwarenessConfig.map(value => value.asEditable),
        dedicatedMasterType.map(value => value),
        dedicatedMasterCount.map(value => value),
        warmEnabled.map(value => value),
        warmType.map(value => value),
        warmCount.map(value => value),
        coldStorageOptions.map(value => value.asEditable)
      )
    def instanceType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def instanceCount: Option[IntegerClass]
    def dedicatedMasterEnabled: Option[Boolean]
    def zoneAwarenessEnabled: Option[Boolean]
    def zoneAwarenessConfig
        : Option[zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly]
    def dedicatedMasterType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def dedicatedMasterCount: Option[IntegerClass]
    def warmEnabled: Option[Boolean]
    def warmType
        : Option[zio.aws.elasticsearch.model.ESWarmPartitionInstanceType]
    def warmCount: Option[IntegerClass]
    def coldStorageOptions
        : Option[zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly]
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
    def getDedicatedMasterEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("dedicatedMasterEnabled", dedicatedMasterEnabled)
    def getZoneAwarenessEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("zoneAwarenessEnabled", zoneAwarenessEnabled)
    def getZoneAwarenessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("zoneAwarenessConfig", zoneAwarenessConfig)
    def getDedicatedMasterType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField("dedicatedMasterType", dedicatedMasterType)
    def getDedicatedMasterCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("dedicatedMasterCount", dedicatedMasterCount)
    def getWarmEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("warmEnabled", warmEnabled)
    def getWarmType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESWarmPartitionInstanceType
    ] = AwsError.unwrapOptionField("warmType", warmType)
    def getWarmCount: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("warmCount", warmCount)
    def getColdStorageOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly
    ] = AwsError.unwrapOptionField("coldStorageOptions", coldStorageOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ) extends zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly {
    override val instanceType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType] = scala
      .Option(impl.instanceType())
      .map(value =>
        zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
      )
    override val instanceCount: Option[IntegerClass] = scala
      .Option(impl.instanceCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val dedicatedMasterEnabled: Option[Boolean] =
      scala.Option(impl.dedicatedMasterEnabled()).map(value => value: Boolean)
    override val zoneAwarenessEnabled: Option[Boolean] =
      scala.Option(impl.zoneAwarenessEnabled()).map(value => value: Boolean)
    override val zoneAwarenessConfig
        : Option[zio.aws.elasticsearch.model.ZoneAwarenessConfig.ReadOnly] =
      scala
        .Option(impl.zoneAwarenessConfig())
        .map(value =>
          zio.aws.elasticsearch.model.ZoneAwarenessConfig.wrap(value)
        )
    override val dedicatedMasterType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType] = scala
      .Option(impl.dedicatedMasterType())
      .map(value =>
        zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
      )
    override val dedicatedMasterCount: Option[IntegerClass] = scala
      .Option(impl.dedicatedMasterCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val warmEnabled: Option[Boolean] =
      scala.Option(impl.warmEnabled()).map(value => value: Boolean)
    override val warmType
        : Option[zio.aws.elasticsearch.model.ESWarmPartitionInstanceType] =
      scala
        .Option(impl.warmType())
        .map(value =>
          zio.aws.elasticsearch.model.ESWarmPartitionInstanceType.wrap(value)
        )
    override val warmCount: Option[IntegerClass] = scala
      .Option(impl.warmCount())
      .map(value => zio.aws.elasticsearch.model.primitives.IntegerClass(value))
    override val coldStorageOptions
        : Option[zio.aws.elasticsearch.model.ColdStorageOptions.ReadOnly] =
      scala
        .Option(impl.coldStorageOptions())
        .map(value =>
          zio.aws.elasticsearch.model.ColdStorageOptions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig
  ): zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly =
    new Wrapper(impl)
}
