package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeReservedElasticsearchInstanceOfferingsResponse(
    nextToken: Option[NextToken] = None,
    reservedElasticsearchInstanceOfferings: Option[Iterable[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse = {
    import DescribeReservedElasticsearchInstanceOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        reservedElasticsearchInstanceOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedElasticsearchInstanceOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedElasticsearchInstanceOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse =
      zio.aws.elasticsearch.model
        .DescribeReservedElasticsearchInstanceOfferingsResponse(
          nextToken.map(value => value),
          reservedElasticsearchInstanceOfferings.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Option[NextToken]
    def reservedElasticsearchInstanceOfferings: Option[List[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedElasticsearchInstanceOfferings: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedElasticsearchInstanceOfferings",
      reservedElasticsearchInstanceOfferings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse
  ) extends zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
    override val reservedElasticsearchInstanceOfferings: Option[List[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
    ]] = scala
      .Option(impl.reservedElasticsearchInstanceOfferings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse
  ): zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
