package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{NextToken, MaxResults}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePackagesRequest(
    filters: Option[
      Iterable[zio.aws.elasticsearch.model.DescribePackagesFilter]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest = {
    import DescribePackagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DescribePackagesRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribePackagesRequest.wrap(buildAwsValue())
}
object DescribePackagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribePackagesRequest =
      zio.aws.elasticsearch.model.DescribePackagesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[
      List[zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly]
    ]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest
  ) extends zio.aws.elasticsearch.model.DescribePackagesRequest.ReadOnly {
    override val filters: Option[
      List[zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly]
    ] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.DescribePackagesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest
  ): zio.aws.elasticsearch.model.DescribePackagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
