package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeElasticsearchDomainConfigRequest(
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest = {
    import DescribeElasticsearchDomainConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigRequest
      .wrap(buildAwsValue())
}
object DescribeElasticsearchDomainConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigRequest =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchDomainConfigRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest
  ): zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigRequest.ReadOnly =
    new Wrapper(impl)
}
