package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AdvancedSecurityOptions(
    enabled: Option[Boolean] = None,
    internalUserDatabaseEnabled: Option[Boolean] = None,
    samlOptions: Option[zio.aws.elasticsearch.model.SAMLOptionsOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions = {
    import AdvancedSecurityOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptions.wrap(buildAwsValue())
}
object AdvancedSecurityOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptions =
      zio.aws.elasticsearch.model.AdvancedSecurityOptions(
        enabled.map(value => value),
        internalUserDatabaseEnabled.map(value => value),
        samlOptions.map(value => value.asEditable)
      )
    def enabled: Option[Boolean]
    def internalUserDatabaseEnabled: Option[Boolean]
    def samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Option[Boolean] = scala
      .Option(impl.internalUserDatabaseEnabled())
      .map(value => value: Boolean)
    override val samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly] = scala
      .Option(impl.samlOptions())
      .map(value => zio.aws.elasticsearch.model.SAMLOptionsOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptions
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptions.ReadOnly = new Wrapper(
    impl
  )
}
