package zio.aws.elasticsearch.model
import java.lang.Integer
import zio.aws.elasticsearch.model.primitives.{NextToken, MaxResults, PackageID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDomainsForPackageRequest(
    packageID: PackageID,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest = {
    import ListDomainsForPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListDomainsForPackageRequest
      .wrap(buildAwsValue())
}
object ListDomainsForPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListDomainsForPackageRequest =
      zio.aws.elasticsearch.model.ListDomainsForPackageRequest(
        packageID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def packageID: PackageID
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ) extends zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ): zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly =
    new Wrapper(impl)
}
