package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InboundCrossClusterSearchConnection(
    sourceDomainInfo: Option[zio.aws.elasticsearch.model.DomainInformation] =
      None,
    destinationDomainInfo: Option[
      zio.aws.elasticsearch.model.DomainInformation
    ] = None,
    crossClusterSearchConnectionId: Option[CrossClusterSearchConnectionId] =
      None,
    connectionStatus: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection = {
    import InboundCrossClusterSearchConnection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
      .builder()
      .optionallyWith(sourceDomainInfo.map(value => value.buildAwsValue()))(
        _.sourceDomainInfo
      )
      .optionallyWith(
        destinationDomainInfo.map(value => value.buildAwsValue())
      )(_.destinationDomainInfo)
      .optionallyWith(
        crossClusterSearchConnectionId.map(value =>
          CrossClusterSearchConnectionId.unwrap(value): java.lang.String
        )
      )(_.crossClusterSearchConnectionId)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly =
    zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
      .wrap(buildAwsValue())
}
object InboundCrossClusterSearchConnection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection =
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection(
        sourceDomainInfo.map(value => value.asEditable),
        destinationDomainInfo.map(value => value.asEditable),
        crossClusterSearchConnectionId.map(value => value),
        connectionStatus.map(value => value.asEditable)
      )
    def sourceDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def destinationDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def crossClusterSearchConnectionId: Option[CrossClusterSearchConnectionId]
    def connectionStatus: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ]
    def getSourceDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDomainInfo", sourceDomainInfo)
    def getDestinationDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationDomainInfo", destinationDomainInfo)
    def getCrossClusterSearchConnectionId
        : ZIO[Any, AwsError, CrossClusterSearchConnectionId] =
      AwsError.unwrapOptionField(
        "crossClusterSearchConnectionId",
        crossClusterSearchConnectionId
      )
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ) extends zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly {
    override val sourceDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] = scala
      .Option(impl.sourceDomainInfo())
      .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val destinationDomainInfo
        : Option[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] = scala
      .Option(impl.destinationDomainInfo())
      .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val crossClusterSearchConnectionId
        : Option[CrossClusterSearchConnectionId] = scala
      .Option(impl.crossClusterSearchConnectionId())
      .map(value =>
        zio.aws.elasticsearch.model.primitives
          .CrossClusterSearchConnectionId(value)
      )
    override val connectionStatus: Option[
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = scala
      .Option(impl.connectionStatus())
      .map(value =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnectionStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.InboundCrossClusterSearchConnection
  ): zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly =
    new Wrapper(impl)
}
