package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AdvancedSecurityOptionsInput(
    enabled: Option[Boolean] = None,
    internalUserDatabaseEnabled: Option[Boolean] = None,
    masterUserOptions: Option[zio.aws.elasticsearch.model.MasterUserOptions] =
      None,
    samlOptions: Option[zio.aws.elasticsearch.model.SAMLOptionsInput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput = {
    import AdvancedSecurityOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        internalUserDatabaseEnabled.map(value => value: java.lang.Boolean)
      )(_.internalUserDatabaseEnabled)
      .optionallyWith(masterUserOptions.map(value => value.buildAwsValue()))(
        _.masterUserOptions
      )
      .optionallyWith(samlOptions.map(value => value.buildAwsValue()))(
        _.samlOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly =
    zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput
      .wrap(buildAwsValue())
}
object AdvancedSecurityOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput =
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput(
        enabled.map(value => value),
        internalUserDatabaseEnabled.map(value => value),
        masterUserOptions.map(value => value.asEditable),
        samlOptions.map(value => value.asEditable)
      )
    def enabled: Option[Boolean]
    def internalUserDatabaseEnabled: Option[Boolean]
    def masterUserOptions
        : Option[zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly]
    def samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getInternalUserDatabaseEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "internalUserDatabaseEnabled",
        internalUserDatabaseEnabled
      )
    def getMasterUserOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly
    ] = AwsError.unwrapOptionField("masterUserOptions", masterUserOptions)
    def getSamlOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField("samlOptions", samlOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ) extends zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly {
    override val enabled: Option[Boolean] =
      scala.Option(impl.enabled()).map(value => value: Boolean)
    override val internalUserDatabaseEnabled: Option[Boolean] = scala
      .Option(impl.internalUserDatabaseEnabled())
      .map(value => value: Boolean)
    override val masterUserOptions
        : Option[zio.aws.elasticsearch.model.MasterUserOptions.ReadOnly] = scala
      .Option(impl.masterUserOptions())
      .map(value => zio.aws.elasticsearch.model.MasterUserOptions.wrap(value))
    override val samlOptions
        : Option[zio.aws.elasticsearch.model.SAMLOptionsInput.ReadOnly] = scala
      .Option(impl.samlOptions())
      .map(value => zio.aws.elasticsearch.model.SAMLOptionsInput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AdvancedSecurityOptionsInput
  ): zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly =
    new Wrapper(impl)
}
