package zio.aws.elasticsearch
import zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.elasticsearch.model.{
  DeleteOutboundCrossClusterSearchConnectionRequest,
  ListElasticsearchInstanceTypesRequest,
  AssociatePackageRequest,
  DescribeOutboundCrossClusterSearchConnectionsRequest,
  GetUpgradeHistoryRequest,
  DeleteElasticsearchDomainRequest,
  GetCompatibleElasticsearchVersionsRequest,
  DescribePackagesRequest,
  DescribeElasticsearchDomainConfigRequest,
  RejectInboundCrossClusterSearchConnectionRequest,
  DescribeElasticsearchDomainsRequest,
  ListTagsRequest,
  DescribeElasticsearchDomainRequest,
  UpgradeElasticsearchDomainRequest,
  DescribeDomainAutoTunesRequest,
  CancelElasticsearchServiceSoftwareUpdateRequest,
  ListElasticsearchVersionsRequest,
  ListPackagesForDomainRequest,
  DeletePackageRequest,
  GetPackageVersionHistoryRequest,
  CreatePackageRequest,
  AddTagsRequest,
  ListDomainNamesRequest,
  DescribeElasticsearchInstanceTypeLimitsRequest,
  GetUpgradeStatusRequest,
  AcceptInboundCrossClusterSearchConnectionRequest,
  DescribeInboundCrossClusterSearchConnectionsRequest,
  PurchaseReservedElasticsearchInstanceOfferingRequest,
  CreateElasticsearchDomainRequest,
  CreateOutboundCrossClusterSearchConnectionRequest,
  DescribeReservedElasticsearchInstanceOfferingsRequest,
  ESPartitionInstanceType,
  StartElasticsearchServiceSoftwareUpdateRequest,
  DissociatePackageRequest,
  UpdateElasticsearchDomainConfigRequest,
  RemoveTagsRequest,
  ListDomainsForPackageRequest,
  DescribeReservedElasticsearchInstancesRequest,
  UpdatePackageRequest,
  DeleteInboundCrossClusterSearchConnectionRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.elasticsearch.model.{
  PurchaseReservedElasticsearchInstanceOfferingResponse,
  DescribeElasticsearchDomainsResponse,
  DeleteElasticsearchServiceRoleRequest,
  PackageDetails,
  OutboundCrossClusterSearchConnection,
  GetUpgradeStatusResponse,
  DeleteInboundCrossClusterSearchConnectionResponse,
  UpdatePackageResponse,
  DescribeElasticsearchDomainConfigResponse,
  AssociatePackageResponse,
  CreateOutboundCrossClusterSearchConnectionResponse,
  GetPackageVersionHistoryResponse,
  ListPackagesForDomainResponse,
  CreatePackageResponse,
  DescribeInboundCrossClusterSearchConnectionsResponse,
  ListElasticsearchInstanceTypesResponse,
  RemoveTagsResponse,
  ReservedElasticsearchInstanceOffering,
  ListDomainsForPackageResponse,
  PackageVersionHistory,
  UpgradeElasticsearchDomainResponse,
  DomainPackageDetails,
  DescribeReservedElasticsearchInstancesResponse,
  DescribeElasticsearchDomainResponse,
  DeleteElasticsearchDomainResponse,
  AutoTune,
  AcceptInboundCrossClusterSearchConnectionResponse,
  UpgradeHistory,
  DissociatePackageResponse,
  DeleteOutboundCrossClusterSearchConnectionResponse,
  ListElasticsearchVersionsResponse,
  AddTagsResponse,
  DescribeOutboundCrossClusterSearchConnectionsResponse,
  DescribeReservedElasticsearchInstanceOfferingsResponse,
  CreateElasticsearchDomainResponse,
  ReservedElasticsearchInstance,
  InboundCrossClusterSearchConnection,
  GetCompatibleElasticsearchVersionsResponse,
  GetUpgradeHistoryResponse,
  UpdateElasticsearchDomainConfigResponse,
  CancelElasticsearchServiceSoftwareUpdateResponse,
  RejectInboundCrossClusterSearchConnectionResponse,
  DeleteElasticsearchServiceRoleResponse,
  DescribeElasticsearchInstanceTypeLimitsResponse,
  DeletePackageResponse,
  StartElasticsearchServiceSoftwareUpdateResponse,
  DescribeDomainAutoTunesResponse,
  ListDomainNamesResponse,
  ListTagsResponse,
  DescribePackagesResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.elasticsearch.{
  ElasticsearchAsyncClientBuilder,
  ElasticsearchAsyncClient
}
import zio.stream.ZStream
import zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString
import scala.jdk.CollectionConverters.*
trait Elasticsearch extends AspectSupport[Elasticsearch] {
  val api: ElasticsearchAsyncClient
  def describePackages(
      request: DescribePackagesRequest
  ): ZStream[Any, AwsError, zio.aws.elasticsearch.model.PackageDetails.ReadOnly]
  def describePackagesPaginated(
      request: DescribePackagesRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly]
  def deleteInboundCrossClusterSearchConnection(
      request: DeleteInboundCrossClusterSearchConnectionRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly
  ]
  def describeElasticsearchDomains(
      request: DescribeElasticsearchDomainsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly
  ]
  def associatePackage(
      request: AssociatePackageRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly]
  def describeReservedElasticsearchInstanceOfferings(
      request: DescribeReservedElasticsearchInstanceOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
  ]
  def describeReservedElasticsearchInstanceOfferingsPaginated(
      request: DescribeReservedElasticsearchInstanceOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly
  ]
  def describeReservedElasticsearchInstances(
      request: DescribeReservedElasticsearchInstancesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
  ]
  def describeReservedElasticsearchInstancesPaginated(
      request: DescribeReservedElasticsearchInstancesRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly
  ]
  def createPackage(
      request: CreatePackageRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly]
  def listTags(
      request: ListTagsRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.ListTagsResponse.ReadOnly]
  def addTags(request: AddTagsRequest): IO[AwsError, Unit]
  def dissociatePackage(request: DissociatePackageRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly
  ]
  def listElasticsearchInstanceTypes(
      request: ListElasticsearchInstanceTypesRequest
  ): ZStream[Any, AwsError, ESPartitionInstanceType]
  def listElasticsearchInstanceTypesPaginated(
      request: ListElasticsearchInstanceTypesRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly
  ]
  def getCompatibleElasticsearchVersions(
      request: GetCompatibleElasticsearchVersionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly
  ]
  def createElasticsearchDomain(request: CreateElasticsearchDomainRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly
  ]
  def listDomainsForPackage(request: ListDomainsForPackageRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
  ]
  def listDomainsForPackagePaginated(request: ListDomainsForPackageRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly
  ]
  def removeTags(request: RemoveTagsRequest): IO[AwsError, Unit]
  def getUpgradeHistory(
      request: GetUpgradeHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly]
  def getUpgradeHistoryPaginated(request: GetUpgradeHistoryRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly
  ]
  def describeElasticsearchDomain(
      request: DescribeElasticsearchDomainRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly
  ]
  def deleteOutboundCrossClusterSearchConnection(
      request: DeleteOutboundCrossClusterSearchConnectionRequest
  ): IO[AwsError, ReadOnly]
  def createOutboundCrossClusterSearchConnection(
      request: CreateOutboundCrossClusterSearchConnectionRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly
  ]
  def deleteElasticsearchDomain(request: DeleteElasticsearchDomainRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly
  ]
  def listPackagesForDomain(request: ListPackagesForDomainRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
  ]
  def listPackagesForDomainPaginated(request: ListPackagesForDomainRequest): IO[
    AwsError,
    zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly
  ]
  def cancelElasticsearchServiceSoftwareUpdate(
      request: CancelElasticsearchServiceSoftwareUpdateRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly
  ]
  def getPackageVersionHistory(
      request: GetPackageVersionHistoryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly,
    zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
  ]]
  def getPackageVersionHistoryPaginated(
      request: GetPackageVersionHistoryRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly
  ]
  def startElasticsearchServiceSoftwareUpdate(
      request: StartElasticsearchServiceSoftwareUpdateRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly
  ]
  def describeOutboundCrossClusterSearchConnections(
      request: DescribeOutboundCrossClusterSearchConnectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
  ]
  def describeOutboundCrossClusterSearchConnectionsPaginated(
      request: DescribeOutboundCrossClusterSearchConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly
  ]
  def describeDomainAutoTunes(
      request: DescribeDomainAutoTunesRequest
  ): ZStream[Any, AwsError, zio.aws.elasticsearch.model.AutoTune.ReadOnly]
  def describeDomainAutoTunesPaginated(
      request: DescribeDomainAutoTunesRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly
  ]
  def describeElasticsearchDomainConfig(
      request: DescribeElasticsearchDomainConfigRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly
  ]
  def updatePackage(
      request: UpdatePackageRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly]
  def deletePackage(
      request: DeletePackageRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly]
  def rejectInboundCrossClusterSearchConnection(
      request: RejectInboundCrossClusterSearchConnectionRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly
  ]
  def upgradeElasticsearchDomain(
      request: UpgradeElasticsearchDomainRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly
  ]
  def purchaseReservedElasticsearchInstanceOffering(
      request: PurchaseReservedElasticsearchInstanceOfferingRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly
  ]
  def getUpgradeStatus(
      request: GetUpgradeStatusRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly]
  def deleteElasticsearchServiceRole(): IO[AwsError, Unit]
  def updateElasticsearchDomainConfig(
      request: UpdateElasticsearchDomainConfigRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly
  ]
  def listDomainNames(
      request: ListDomainNamesRequest
  ): IO[AwsError, zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly]
  def describeInboundCrossClusterSearchConnections(
      request: DescribeInboundCrossClusterSearchConnectionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
  ]
  def describeInboundCrossClusterSearchConnectionsPaginated(
      request: DescribeInboundCrossClusterSearchConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly
  ]
  def acceptInboundCrossClusterSearchConnection(
      request: AcceptInboundCrossClusterSearchConnectionRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly
  ]
  def listElasticsearchVersions(
      request: ListElasticsearchVersionsRequest
  ): ZStream[Any, AwsError, ElasticsearchVersionString]
  def listElasticsearchVersionsPaginated(
      request: ListElasticsearchVersionsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly
  ]
  def describeElasticsearchInstanceTypeLimits(
      request: DescribeElasticsearchInstanceTypeLimitsRequest
  ): IO[
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly
  ]
}
object Elasticsearch {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Elasticsearch] = customized(
    identity
  )
  def customized(
      customization: ElasticsearchAsyncClientBuilder => ElasticsearchAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Elasticsearch] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticsearchAsyncClientBuilder => ElasticsearchAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Elasticsearch] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticsearchAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ElasticsearchAsyncClient, ElasticsearchAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticsearchAsyncClient,
        ElasticsearchAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticsearchImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticsearchImpl[R](
      override val api: ElasticsearchAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Elasticsearch
      with AwsServiceBase[R] {
    override val serviceName: String = "Elasticsearch"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticsearchImpl[R1] = new ElasticsearchImpl(api, newAspect, r)
    def describePackages(request: DescribePackagesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest,
      DescribePackagesResponse,
      PackageDetails
    ](
      "describePackages",
      api.describePackages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticsearch.model.PackageDetails.wrap(item))
      .provideEnvironment(r)
    def describePackagesPaginated(request: DescribePackagesRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesRequest,
      DescribePackagesResponse
    ]("describePackages", api.describePackages)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.DescribePackagesResponse.wrap)
      .provideEnvironment(r)
    def deleteInboundCrossClusterSearchConnection(
        request: DeleteInboundCrossClusterSearchConnectionRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionRequest,
      DeleteInboundCrossClusterSearchConnectionResponse
    ](
      "deleteInboundCrossClusterSearchConnection",
      api.deleteInboundCrossClusterSearchConnection
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.wrap
      )
      .provideEnvironment(r)
    def describeElasticsearchDomains(
        request: DescribeElasticsearchDomainsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest,
      DescribeElasticsearchDomainsResponse
    ]("describeElasticsearchDomains", api.describeElasticsearchDomains)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.wrap)
      .provideEnvironment(r)
    def associatePackage(request: AssociatePackageRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.AssociatePackageRequest,
      AssociatePackageResponse
    ]("associatePackage", api.associatePackage)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.AssociatePackageResponse.wrap)
      .provideEnvironment(r)
    def describeReservedElasticsearchInstanceOfferings(
        request: DescribeReservedElasticsearchInstanceOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest,
      DescribeReservedElasticsearchInstanceOfferingsResponse,
      ReservedElasticsearchInstanceOffering
    ](
      "describeReservedElasticsearchInstanceOfferings",
      api.describeReservedElasticsearchInstanceOfferings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.reservedElasticsearchInstanceOfferings().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeReservedElasticsearchInstanceOfferingsPaginated(
        request: DescribeReservedElasticsearchInstanceOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsRequest,
      DescribeReservedElasticsearchInstanceOfferingsResponse
    ](
      "describeReservedElasticsearchInstanceOfferings",
      api.describeReservedElasticsearchInstanceOfferings
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.wrap
      )
      .provideEnvironment(r)
    def describeReservedElasticsearchInstances(
        request: DescribeReservedElasticsearchInstancesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest,
      DescribeReservedElasticsearchInstancesResponse,
      ReservedElasticsearchInstance
    ](
      "describeReservedElasticsearchInstances",
      api.describeReservedElasticsearchInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reservedElasticsearchInstances().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticsearch.model.ReservedElasticsearchInstance.wrap(item)
      )
      .provideEnvironment(r)
    def describeReservedElasticsearchInstancesPaginated(
        request: DescribeReservedElasticsearchInstancesRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesRequest,
      DescribeReservedElasticsearchInstancesResponse
    ](
      "describeReservedElasticsearchInstances",
      api.describeReservedElasticsearchInstances
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.wrap
      )
      .provideEnvironment(r)
    def createPackage(request: CreatePackageRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest,
      CreatePackageResponse
    ]("createPackage", api.createPackage)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.CreatePackageResponse.wrap)
      .provideEnvironment(r)
    def listTags(
        request: ListTagsRequest
    ): IO[AwsError, zio.aws.elasticsearch.model.ListTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticsearch.model.ListTagsRequest,
        ListTagsResponse
      ]("listTags", api.listTags)(request.buildAwsValue())
        .map(zio.aws.elasticsearch.model.ListTagsResponse.wrap)
        .provideEnvironment(r)
    def addTags(request: AddTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticsearch.model.AddTagsRequest,
        AddTagsResponse
      ]("addTags", api.addTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def dissociatePackage(request: DissociatePackageRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest,
      DissociatePackageResponse
    ]("dissociatePackage", api.dissociatePackage)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.DissociatePackageResponse.wrap)
      .provideEnvironment(r)
    def listElasticsearchInstanceTypes(
        request: ListElasticsearchInstanceTypesRequest
    ): ZStream[Any, AwsError, ESPartitionInstanceType] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest,
        ListElasticsearchInstanceTypesResponse,
        software.amazon.awssdk.services.elasticsearch.model.ESPartitionInstanceType
      ](
        "listElasticsearchInstanceTypes",
        api.listElasticsearchInstanceTypes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.elasticsearchInstanceTypes().asScala)
      )(request.buildAwsValue())
        .map(item => ESPartitionInstanceType.wrap(item))
        .provideEnvironment(r)
    def listElasticsearchInstanceTypesPaginated(
        request: ListElasticsearchInstanceTypesRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest,
      ListElasticsearchInstanceTypesResponse
    ]("listElasticsearchInstanceTypes", api.listElasticsearchInstanceTypes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.wrap
    ).provideEnvironment(r)
    def getCompatibleElasticsearchVersions(
        request: GetCompatibleElasticsearchVersionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest,
      GetCompatibleElasticsearchVersionsResponse
    ](
      "getCompatibleElasticsearchVersions",
      api.getCompatibleElasticsearchVersions
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.wrap
      )
      .provideEnvironment(r)
    def createElasticsearchDomain(
        request: CreateElasticsearchDomainRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.CreateElasticsearchDomainRequest,
      CreateElasticsearchDomainResponse
    ]("createElasticsearchDomain", api.createElasticsearchDomain)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.wrap)
      .provideEnvironment(r)
    def listDomainsForPackage(request: ListDomainsForPackageRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest,
      ListDomainsForPackageResponse,
      DomainPackageDetails
    ](
      "listDomainsForPackage",
      api.listDomainsForPackage,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainPackageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticsearch.model.DomainPackageDetails.wrap(item))
      .provideEnvironment(r)
    def listDomainsForPackagePaginated(
        request: ListDomainsForPackageRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest,
      ListDomainsForPackageResponse
    ]("listDomainsForPackage", api.listDomainsForPackage)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.ListDomainsForPackageResponse.wrap)
      .provideEnvironment(r)
    def removeTags(request: RemoveTagsRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.elasticsearch.model.RemoveTagsRequest,
        RemoveTagsResponse
      ]("removeTags", api.removeTags)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def getUpgradeHistory(request: GetUpgradeHistoryRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest,
      GetUpgradeHistoryResponse,
      UpgradeHistory
    ](
      "getUpgradeHistory",
      api.getUpgradeHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.upgradeHistories().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticsearch.model.UpgradeHistory.wrap(item))
      .provideEnvironment(r)
    def getUpgradeHistoryPaginated(request: GetUpgradeHistoryRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest,
      GetUpgradeHistoryResponse
    ]("getUpgradeHistory", api.getUpgradeHistory)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.wrap)
      .provideEnvironment(r)
    def describeElasticsearchDomain(
        request: DescribeElasticsearchDomainRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainRequest,
      DescribeElasticsearchDomainResponse
    ]("describeElasticsearchDomain", api.describeElasticsearchDomain)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.wrap)
      .provideEnvironment(r)
    def deleteOutboundCrossClusterSearchConnection(
        request: DeleteOutboundCrossClusterSearchConnectionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionRequest,
      DeleteOutboundCrossClusterSearchConnectionResponse
    ](
      "deleteOutboundCrossClusterSearchConnection",
      api.deleteOutboundCrossClusterSearchConnection
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.wrap
      )
      .provideEnvironment(r)
    def createOutboundCrossClusterSearchConnection(
        request: CreateOutboundCrossClusterSearchConnectionRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest,
      CreateOutboundCrossClusterSearchConnectionResponse
    ](
      "createOutboundCrossClusterSearchConnection",
      api.createOutboundCrossClusterSearchConnection
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.wrap
      )
      .provideEnvironment(r)
    def deleteElasticsearchDomain(
        request: DeleteElasticsearchDomainRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainRequest,
      DeleteElasticsearchDomainResponse
    ]("deleteElasticsearchDomain", api.deleteElasticsearchDomain)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.wrap)
      .provideEnvironment(r)
    def listPackagesForDomain(request: ListPackagesForDomainRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest,
      ListPackagesForDomainResponse,
      DomainPackageDetails
    ](
      "listPackagesForDomain",
      api.listPackagesForDomain,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.domainPackageDetailsList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.elasticsearch.model.DomainPackageDetails.wrap(item))
      .provideEnvironment(r)
    def listPackagesForDomainPaginated(
        request: ListPackagesForDomainRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.ListPackagesForDomainRequest,
      ListPackagesForDomainResponse
    ]("listPackagesForDomain", api.listPackagesForDomain)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.ListPackagesForDomainResponse.wrap)
      .provideEnvironment(r)
    def cancelElasticsearchServiceSoftwareUpdate(
        request: CancelElasticsearchServiceSoftwareUpdateRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateRequest,
      CancelElasticsearchServiceSoftwareUpdateResponse
    ](
      "cancelElasticsearchServiceSoftwareUpdate",
      api.cancelElasticsearchServiceSoftwareUpdate
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.wrap
      )
      .provideEnvironment(r)
    def getPackageVersionHistory(
        request: GetPackageVersionHistoryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly,
      zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest,
      GetPackageVersionHistoryResponse,
      PackageVersionHistory
    ](
      "getPackageVersionHistory",
      api.getPackageVersionHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.packageVersionHistoryList().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.elasticsearch.model.PackageVersionHistory.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getPackageVersionHistoryPaginated(
        request: GetPackageVersionHistoryRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.GetPackageVersionHistoryRequest,
      GetPackageVersionHistoryResponse
    ]("getPackageVersionHistory", api.getPackageVersionHistory)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.wrap)
      .provideEnvironment(r)
    def startElasticsearchServiceSoftwareUpdate(
        request: StartElasticsearchServiceSoftwareUpdateRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest,
      StartElasticsearchServiceSoftwareUpdateResponse
    ](
      "startElasticsearchServiceSoftwareUpdate",
      api.startElasticsearchServiceSoftwareUpdate
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.wrap
      )
      .provideEnvironment(r)
    def describeOutboundCrossClusterSearchConnections(
        request: DescribeOutboundCrossClusterSearchConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest,
      DescribeOutboundCrossClusterSearchConnectionsResponse,
      OutboundCrossClusterSearchConnection
    ](
      "describeOutboundCrossClusterSearchConnections",
      api.describeOutboundCrossClusterSearchConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.crossClusterSearchConnections().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeOutboundCrossClusterSearchConnectionsPaginated(
        request: DescribeOutboundCrossClusterSearchConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsRequest,
      DescribeOutboundCrossClusterSearchConnectionsResponse
    ](
      "describeOutboundCrossClusterSearchConnections",
      api.describeOutboundCrossClusterSearchConnections
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.wrap
      )
      .provideEnvironment(r)
    def describeDomainAutoTunes(
        request: DescribeDomainAutoTunesRequest
    ): ZStream[Any, AwsError, zio.aws.elasticsearch.model.AutoTune.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest,
        DescribeDomainAutoTunesResponse,
        AutoTune
      ](
        "describeDomainAutoTunes",
        api.describeDomainAutoTunes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.autoTunes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.elasticsearch.model.AutoTune.wrap(item))
        .provideEnvironment(r)
    def describeDomainAutoTunesPaginated(
        request: DescribeDomainAutoTunesRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesRequest,
      DescribeDomainAutoTunesResponse
    ]("describeDomainAutoTunes", api.describeDomainAutoTunes)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.wrap)
      .provideEnvironment(r)
    def describeElasticsearchDomainConfig(
        request: DescribeElasticsearchDomainConfigRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainConfigRequest,
      DescribeElasticsearchDomainConfigResponse
    ](
      "describeElasticsearchDomainConfig",
      api.describeElasticsearchDomainConfig
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.wrap
      )
      .provideEnvironment(r)
    def updatePackage(request: UpdatePackageRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.UpdatePackageRequest,
      UpdatePackageResponse
    ]("updatePackage", api.updatePackage)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.UpdatePackageResponse.wrap)
      .provideEnvironment(r)
    def deletePackage(request: DeletePackageRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DeletePackageRequest,
      DeletePackageResponse
    ]("deletePackage", api.deletePackage)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.DeletePackageResponse.wrap)
      .provideEnvironment(r)
    def rejectInboundCrossClusterSearchConnection(
        request: RejectInboundCrossClusterSearchConnectionRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.RejectInboundCrossClusterSearchConnectionRequest,
      RejectInboundCrossClusterSearchConnectionResponse
    ](
      "rejectInboundCrossClusterSearchConnection",
      api.rejectInboundCrossClusterSearchConnection
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.wrap
      )
      .provideEnvironment(r)
    def upgradeElasticsearchDomain(
        request: UpgradeElasticsearchDomainRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest,
      UpgradeElasticsearchDomainResponse
    ]("upgradeElasticsearchDomain", api.upgradeElasticsearchDomain)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.wrap)
      .provideEnvironment(r)
    def purchaseReservedElasticsearchInstanceOffering(
        request: PurchaseReservedElasticsearchInstanceOfferingRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest,
      PurchaseReservedElasticsearchInstanceOfferingResponse
    ](
      "purchaseReservedElasticsearchInstanceOffering",
      api.purchaseReservedElasticsearchInstanceOffering
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.wrap
      )
      .provideEnvironment(r)
    def getUpgradeStatus(request: GetUpgradeStatusRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusRequest,
      GetUpgradeStatusResponse
    ]("getUpgradeStatus", api.getUpgradeStatus)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.GetUpgradeStatusResponse.wrap)
      .provideEnvironment(r)
    def deleteElasticsearchServiceRole(): IO[AwsError, Unit] =
      asyncRequestResponse[
        DeleteElasticsearchServiceRoleRequest,
        DeleteElasticsearchServiceRoleResponse
      ]("deleteElasticsearchServiceRole", api.deleteElasticsearchServiceRole)(
        DeleteElasticsearchServiceRoleRequest.builder().build()
      ).unit.provideEnvironment(r)
    def updateElasticsearchDomainConfig(
        request: UpdateElasticsearchDomainConfigRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest,
      UpdateElasticsearchDomainConfigResponse
    ]("updateElasticsearchDomainConfig", api.updateElasticsearchDomainConfig)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.wrap
    ).provideEnvironment(r)
    def listDomainNames(request: ListDomainNamesRequest): IO[
      AwsError,
      zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest,
      ListDomainNamesResponse
    ]("listDomainNames", api.listDomainNames)(request.buildAwsValue())
      .map(zio.aws.elasticsearch.model.ListDomainNamesResponse.wrap)
      .provideEnvironment(r)
    def describeInboundCrossClusterSearchConnections(
        request: DescribeInboundCrossClusterSearchConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest,
      DescribeInboundCrossClusterSearchConnectionsResponse,
      InboundCrossClusterSearchConnection
    ](
      "describeInboundCrossClusterSearchConnections",
      api.describeInboundCrossClusterSearchConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.crossClusterSearchConnections().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeInboundCrossClusterSearchConnectionsPaginated(
        request: DescribeInboundCrossClusterSearchConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsRequest,
      DescribeInboundCrossClusterSearchConnectionsResponse
    ](
      "describeInboundCrossClusterSearchConnections",
      api.describeInboundCrossClusterSearchConnections
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.wrap
      )
      .provideEnvironment(r)
    def acceptInboundCrossClusterSearchConnection(
        request: AcceptInboundCrossClusterSearchConnectionRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionRequest,
      AcceptInboundCrossClusterSearchConnectionResponse
    ](
      "acceptInboundCrossClusterSearchConnection",
      api.acceptInboundCrossClusterSearchConnection
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.wrap
      )
      .provideEnvironment(r)
    def listElasticsearchVersions(
        request: ListElasticsearchVersionsRequest
    ): ZStream[Any, AwsError, ElasticsearchVersionString] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest,
        ListElasticsearchVersionsResponse,
        java.lang.String
      ](
        "listElasticsearchVersions",
        api.listElasticsearchVersions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.elasticsearchVersions().asScala)
      )(request.buildAwsValue())
        .map(item =>
          zio.aws.elasticsearch.model.primitives
            .ElasticsearchVersionString(item)
        )
        .provideEnvironment(r)
    def listElasticsearchVersionsPaginated(
        request: ListElasticsearchVersionsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsRequest,
      ListElasticsearchVersionsResponse
    ]("listElasticsearchVersions", api.listElasticsearchVersions)(
      request.buildAwsValue()
    ).map(zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeElasticsearchInstanceTypeLimits(
        request: DescribeElasticsearchInstanceTypeLimitsRequest
    ): IO[
      AwsError,
      zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest,
      DescribeElasticsearchInstanceTypeLimitsResponse
    ](
      "describeElasticsearchInstanceTypeLimits",
      api.describeElasticsearchInstanceTypeLimits
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.wrap
      )
      .provideEnvironment(r)
  }
  def describePackages(request: DescribePackagesRequest): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.PackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.describePackages(request))
  def describePackagesPaginated(request: DescribePackagesRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePackagesPaginated(request))
  def deleteInboundCrossClusterSearchConnection(
      request: DeleteInboundCrossClusterSearchConnectionRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DeleteInboundCrossClusterSearchConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInboundCrossClusterSearchConnection(request))
  def describeElasticsearchDomains(
      request: DescribeElasticsearchDomainsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeElasticsearchDomains(request))
  def associatePackage(request: AssociatePackageRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.AssociatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associatePackage(request))
  def describeReservedElasticsearchInstanceOfferings(
      request: DescribeReservedElasticsearchInstanceOfferingsRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeReservedElasticsearchInstanceOfferings(request)
  )
  def describeReservedElasticsearchInstanceOfferingsPaginated(
      request: DescribeReservedElasticsearchInstanceOfferingsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstanceOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeReservedElasticsearchInstanceOfferingsPaginated(request)
  )
  def describeReservedElasticsearchInstances(
      request: DescribeReservedElasticsearchInstancesRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeReservedElasticsearchInstances(request))
  def describeReservedElasticsearchInstancesPaginated(
      request: DescribeReservedElasticsearchInstancesRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeReservedElasticsearchInstancesPaginated(request)
  )
  def createPackage(request: CreatePackageRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.CreatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPackage(request))
  def listTags(request: ListTagsRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTags(request))
  def addTags(
      request: AddTagsRequest
  ): ZIO[zio.aws.elasticsearch.Elasticsearch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTags(request))
  def dissociatePackage(request: DissociatePackageRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DissociatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.dissociatePackage(request))
  def listElasticsearchInstanceTypes(
      request: ListElasticsearchInstanceTypesRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    ESPartitionInstanceType
  ] = ZStream.serviceWithStream(_.listElasticsearchInstanceTypes(request))
  def listElasticsearchInstanceTypesPaginated(
      request: ListElasticsearchInstanceTypesRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listElasticsearchInstanceTypesPaginated(request))
  def getCompatibleElasticsearchVersions(
      request: GetCompatibleElasticsearchVersionsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCompatibleElasticsearchVersions(request))
  def createElasticsearchDomain(request: CreateElasticsearchDomainRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.CreateElasticsearchDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createElasticsearchDomain(request))
  def listDomainsForPackage(request: ListDomainsForPackageRequest): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listDomainsForPackage(request))
  def listDomainsForPackagePaginated(
      request: ListDomainsForPackageRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListDomainsForPackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainsForPackagePaginated(request))
  def removeTags(
      request: RemoveTagsRequest
  ): ZIO[zio.aws.elasticsearch.Elasticsearch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTags(request))
  def getUpgradeHistory(request: GetUpgradeHistoryRequest): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly
  ] = ZStream.serviceWithStream(_.getUpgradeHistory(request))
  def getUpgradeHistoryPaginated(request: GetUpgradeHistoryRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUpgradeHistoryPaginated(request))
  def describeElasticsearchDomain(
      request: DescribeElasticsearchDomainRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeElasticsearchDomain(request))
  def deleteOutboundCrossClusterSearchConnection(
      request: DeleteOutboundCrossClusterSearchConnectionRequest
  ): ZIO[zio.aws.elasticsearch.Elasticsearch, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.deleteOutboundCrossClusterSearchConnection(request))
  def createOutboundCrossClusterSearchConnection(
      request: CreateOutboundCrossClusterSearchConnectionRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOutboundCrossClusterSearchConnection(request))
  def deleteElasticsearchDomain(request: DeleteElasticsearchDomainRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteElasticsearchDomain(request))
  def listPackagesForDomain(request: ListPackagesForDomainRequest): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly
  ] = ZStream.serviceWithStream(_.listPackagesForDomain(request))
  def listPackagesForDomainPaginated(
      request: ListPackagesForDomainRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListPackagesForDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPackagesForDomainPaginated(request))
  def cancelElasticsearchServiceSoftwareUpdate(
      request: CancelElasticsearchServiceSoftwareUpdateRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelElasticsearchServiceSoftwareUpdate(request))
  def getPackageVersionHistory(
      request: GetPackageVersionHistoryRequest
  ): ZIO[zio.aws.elasticsearch.Elasticsearch, AwsError, StreamingOutputResult[
    Any,
    zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly,
    zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getPackageVersionHistory(request))
  def getPackageVersionHistoryPaginated(
      request: GetPackageVersionHistoryRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.GetPackageVersionHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPackageVersionHistoryPaginated(request))
  def startElasticsearchServiceSoftwareUpdate(
      request: StartElasticsearchServiceSoftwareUpdateRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startElasticsearchServiceSoftwareUpdate(request))
  def describeOutboundCrossClusterSearchConnections(
      request: DescribeOutboundCrossClusterSearchConnectionsRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeOutboundCrossClusterSearchConnections(request)
  )
  def describeOutboundCrossClusterSearchConnectionsPaginated(
      request: DescribeOutboundCrossClusterSearchConnectionsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeOutboundCrossClusterSearchConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeOutboundCrossClusterSearchConnectionsPaginated(request)
  )
  def describeDomainAutoTunes(request: DescribeDomainAutoTunesRequest): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.AutoTune.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDomainAutoTunes(request))
  def describeDomainAutoTunesPaginated(
      request: DescribeDomainAutoTunesRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDomainAutoTunesPaginated(request))
  def describeElasticsearchDomainConfig(
      request: DescribeElasticsearchDomainConfigRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeElasticsearchDomainConfig(request))
  def updatePackage(request: UpdatePackageRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePackage(request))
  def deletePackage(request: DeletePackageRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DeletePackageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePackage(request))
  def rejectInboundCrossClusterSearchConnection(
      request: RejectInboundCrossClusterSearchConnectionRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.RejectInboundCrossClusterSearchConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectInboundCrossClusterSearchConnection(request))
  def upgradeElasticsearchDomain(
      request: UpgradeElasticsearchDomainRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.upgradeElasticsearchDomain(request))
  def purchaseReservedElasticsearchInstanceOffering(
      request: PurchaseReservedElasticsearchInstanceOfferingRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.purchaseReservedElasticsearchInstanceOffering(request))
  def getUpgradeStatus(request: GetUpgradeStatusRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getUpgradeStatus(request))
  def deleteElasticsearchServiceRole()
      : ZIO[zio.aws.elasticsearch.Elasticsearch, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteElasticsearchServiceRole())
  def updateElasticsearchDomainConfig(
      request: UpdateElasticsearchDomainConfigRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateElasticsearchDomainConfig(request))
  def listDomainNames(request: ListDomainNamesRequest): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListDomainNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDomainNames(request))
  def describeInboundCrossClusterSearchConnections(
      request: DescribeInboundCrossClusterSearchConnectionsRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeInboundCrossClusterSearchConnections(request)
  )
  def describeInboundCrossClusterSearchConnectionsPaginated(
      request: DescribeInboundCrossClusterSearchConnectionsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeInboundCrossClusterSearchConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeInboundCrossClusterSearchConnectionsPaginated(request)
  )
  def acceptInboundCrossClusterSearchConnection(
      request: AcceptInboundCrossClusterSearchConnectionRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.AcceptInboundCrossClusterSearchConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptInboundCrossClusterSearchConnection(request))
  def listElasticsearchVersions(
      request: ListElasticsearchVersionsRequest
  ): ZStream[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    ElasticsearchVersionString
  ] = ZStream.serviceWithStream(_.listElasticsearchVersions(request))
  def listElasticsearchVersionsPaginated(
      request: ListElasticsearchVersionsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listElasticsearchVersionsPaginated(request))
  def describeElasticsearchInstanceTypeLimits(
      request: DescribeElasticsearchInstanceTypeLimitsRequest
  ): ZIO[
    zio.aws.elasticsearch.Elasticsearch,
    AwsError,
    zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeElasticsearchInstanceTypeLimits(request))
}
