package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoTuneOptions(
    desiredState: Option[zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      None,
    rollbackOnDisable: Option[zio.aws.elasticsearch.model.RollbackOnDisable] =
      None,
    maintenanceSchedules: Option[
      Iterable[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions = {
    import AutoTuneOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(rollbackOnDisable.map(value => value.unwrap))(
        _.rollbackOnDisable
      )
      .optionallyWith(
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceSchedules)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptions.wrap(buildAwsValue())
}
object AutoTuneOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptions =
      zio.aws.elasticsearch.model.AutoTuneOptions(
        desiredState.map(value => value),
        rollbackOnDisable.map(value => value),
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def desiredState: Option[zio.aws.elasticsearch.model.AutoTuneDesiredState]
    def rollbackOnDisable: Option[zio.aws.elasticsearch.model.RollbackOnDisable]
    def maintenanceSchedules: Option[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getRollbackOnDisable
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.RollbackOnDisable] =
      AwsError.unwrapOptionField("rollbackOnDisable", rollbackOnDisable)
    def getMaintenanceSchedules: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("maintenanceSchedules", maintenanceSchedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions
  ) extends zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly {
    override val desiredState
        : Option[zio.aws.elasticsearch.model.AutoTuneDesiredState] = scala
      .Option(impl.desiredState())
      .map(value =>
        zio.aws.elasticsearch.model.AutoTuneDesiredState.wrap(value)
      )
    override val rollbackOnDisable
        : Option[zio.aws.elasticsearch.model.RollbackOnDisable] = scala
      .Option(impl.rollbackOnDisable())
      .map(value => zio.aws.elasticsearch.model.RollbackOnDisable.wrap(value))
    override val maintenanceSchedules: Option[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ] = scala
      .Option(impl.maintenanceSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptions
  ): zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly = new Wrapper(impl)
}
