package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{NextToken, MaxResults, PackageID}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDomainsForPackageRequest(
    packageID: PackageID,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest = {
    import ListDomainsForPackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListDomainsForPackageRequest
      .wrap(buildAwsValue())
}
object ListDomainsForPackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListDomainsForPackageRequest =
      zio.aws.elasticsearch.model.ListDomainsForPackageRequest(
        packageID,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def packageID: PackageID
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ) extends zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.elasticsearch.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainsForPackageRequest
  ): zio.aws.elasticsearch.model.ListDomainsForPackageRequest.ReadOnly =
    new Wrapper(impl)
}
