package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait EngineType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.EngineType
}
object EngineType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.EngineType
  ): zio.aws.elasticsearch.model.EngineType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.EngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.EngineType.OPEN_SEARCH =>
      val r = OpenSearch
      r
    case software.amazon.awssdk.services.elasticsearch.model.EngineType.ELASTICSEARCH =>
      val r = Elasticsearch
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.EngineType =
      software.amazon.awssdk.services.elasticsearch.model.EngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object OpenSearch extends zio.aws.elasticsearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.EngineType =
      software.amazon.awssdk.services.elasticsearch.model.EngineType.OPEN_SEARCH
  }
  case object Elasticsearch extends zio.aws.elasticsearch.model.EngineType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.EngineType =
      software.amazon.awssdk.services.elasticsearch.model.EngineType.ELASTICSEARCH
  }
}
