package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SnapshotOptionsStatus(
    options: zio.aws.elasticsearch.model.SnapshotOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus = {
    import SnapshotOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.SnapshotOptionsStatus.wrap(buildAwsValue())
}
object SnapshotOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SnapshotOptionsStatus =
      zio.aws.elasticsearch.model
        .SnapshotOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus
  ) extends zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly {
    override val options: zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly =
      zio.aws.elasticsearch.model.SnapshotOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptionsStatus
  ): zio.aws.elasticsearch.model.SnapshotOptionsStatus.ReadOnly = new Wrapper(
    impl
  )
}
