package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{ARN, DomainNameFqdn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DomainEndpointOptions(
    enforceHTTPS: Optional[Boolean] = Optional.Absent,
    tlsSecurityPolicy: Optional[zio.aws.elasticsearch.model.TLSSecurityPolicy] =
      Optional.Absent,
    customEndpointEnabled: Optional[Boolean] = Optional.Absent,
    customEndpoint: Optional[DomainNameFqdn] = Optional.Absent,
    customEndpointCertificateArn: Optional[ARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions = {
    import DomainEndpointOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
      .builder()
      .optionallyWith(enforceHTTPS.map(value => value: java.lang.Boolean))(
        _.enforceHTTPS
      )
      .optionallyWith(tlsSecurityPolicy.map(value => value.unwrap))(
        _.tlsSecurityPolicy
      )
      .optionallyWith(
        customEndpointEnabled.map(value => value: java.lang.Boolean)
      )(_.customEndpointEnabled)
      .optionallyWith(
        customEndpoint.map(value =>
          DomainNameFqdn.unwrap(value): java.lang.String
        )
      )(_.customEndpoint)
      .optionallyWith(
        customEndpointCertificateArn.map(value =>
          ARN.unwrap(value): java.lang.String
        )
      )(_.customEndpointCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly =
    zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(buildAwsValue())
}
object DomainEndpointOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainEndpointOptions =
      zio.aws.elasticsearch.model.DomainEndpointOptions(
        enforceHTTPS.map(value => value),
        tlsSecurityPolicy.map(value => value),
        customEndpointEnabled.map(value => value),
        customEndpoint.map(value => value),
        customEndpointCertificateArn.map(value => value)
      )
    def enforceHTTPS: Optional[Boolean]
    def tlsSecurityPolicy
        : Optional[zio.aws.elasticsearch.model.TLSSecurityPolicy]
    def customEndpointEnabled: Optional[Boolean]
    def customEndpoint: Optional[DomainNameFqdn]
    def customEndpointCertificateArn: Optional[ARN]
    def getEnforceHTTPS: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enforceHTTPS", enforceHTTPS)
    def getTlsSecurityPolicy
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.TLSSecurityPolicy] =
      AwsError.unwrapOptionField("tlsSecurityPolicy", tlsSecurityPolicy)
    def getCustomEndpointEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("customEndpointEnabled", customEndpointEnabled)
    def getCustomEndpoint: ZIO[Any, AwsError, DomainNameFqdn] =
      AwsError.unwrapOptionField("customEndpoint", customEndpoint)
    def getCustomEndpointCertificateArn: ZIO[Any, AwsError, ARN] =
      AwsError.unwrapOptionField(
        "customEndpointCertificateArn",
        customEndpointCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ) extends zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly {
    override val enforceHTTPS: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enforceHTTPS())
      .map(value => value: Boolean)
    override val tlsSecurityPolicy
        : Optional[zio.aws.elasticsearch.model.TLSSecurityPolicy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tlsSecurityPolicy())
        .map(value => zio.aws.elasticsearch.model.TLSSecurityPolicy.wrap(value))
    override val customEndpointEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpointEnabled())
        .map(value => value: Boolean)
    override val customEndpoint: Optional[DomainNameFqdn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpoint())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.DomainNameFqdn(value)
        )
    override val customEndpointCertificateArn: Optional[ARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEndpointCertificateArn())
        .map(value => zio.aws.elasticsearch.model.primitives.ARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainEndpointOptions
  ): zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly = new Wrapper(
    impl
  )
}
