package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NodeToNodeEncryptionOptions(
    enabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions = {
    import NodeToNodeEncryptionOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly =
    zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
      .wrap(buildAwsValue())
}
object NodeToNodeEncryptionOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions =
      zio.aws.elasticsearch.model
        .NodeToNodeEncryptionOptions(enabled.map(value => value))
    def enabled: Optional[Boolean]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions
  ) extends zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptions
  ): zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly =
    new Wrapper(impl)
}
