package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{DomainArn, VpcEndpointId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcEndpointSummary(
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    vpcEndpointOwner: Optional[String] = Optional.Absent,
    domainArn: Optional[DomainArn] = Optional.Absent,
    status: Optional[zio.aws.elasticsearch.model.VpcEndpointStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary = {
    import VpcEndpointSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary
      .builder()
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(vpcEndpointOwner.map(value => value: java.lang.String))(
        _.vpcEndpointOwner
      )
      .optionallyWith(
        domainArn.map(value => DomainArn.unwrap(value): java.lang.String)
      )(_.domainArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly =
    zio.aws.elasticsearch.model.VpcEndpointSummary.wrap(buildAwsValue())
}
object VpcEndpointSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.VpcEndpointSummary =
      zio.aws.elasticsearch.model.VpcEndpointSummary(
        vpcEndpointId.map(value => value),
        vpcEndpointOwner.map(value => value),
        domainArn.map(value => value),
        status.map(value => value)
      )
    def vpcEndpointId: Optional[VpcEndpointId]
    def vpcEndpointOwner: Optional[String]
    def domainArn: Optional[DomainArn]
    def status: Optional[zio.aws.elasticsearch.model.VpcEndpointStatus]
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getVpcEndpointOwner: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcEndpointOwner", vpcEndpointOwner)
    def getDomainArn: ZIO[Any, AwsError, DomainArn] =
      AwsError.unwrapOptionField("domainArn", domainArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VpcEndpointStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary
  ) extends zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly {
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.elasticsearch.model.primitives.VpcEndpointId(value))
    override val vpcEndpointOwner: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointOwner())
      .map(value => value: String)
    override val domainArn: Optional[DomainArn] = zio.aws.core.internal
      .optionalFromNullable(impl.domainArn())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainArn(value))
    override val status
        : Optional[zio.aws.elasticsearch.model.VpcEndpointStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.elasticsearch.model.VpcEndpointStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.VpcEndpointSummary
  ): zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly = new Wrapper(impl)
}
