package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait DescribePackagesFilterName {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName
}
object DescribePackagesFilterName {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName
  ): zio.aws.elasticsearch.model.DescribePackagesFilterName = value match {
    case software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_ID =>
      val r = PackageID
      r
    case software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_NAME =>
      val r = PackageName
      r
    case software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_STATUS =>
      val r = PackageStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object PackageID
      extends zio.aws.elasticsearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_ID
  }
  case object PackageName
      extends zio.aws.elasticsearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_NAME
  }
  case object PackageStatus
      extends zio.aws.elasticsearch.model.DescribePackagesFilterName {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName =
      software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilterName.PACKAGE_STATUS
  }
}
