package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait ScheduledAutoTuneActionType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType
}
object ScheduledAutoTuneActionType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType
  ): zio.aws.elasticsearch.model.ScheduledAutoTuneActionType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.JVM_HEAP_SIZE_TUNING =>
      val r = JVM_HEAP_SIZE_TUNING
      r
    case software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.JVM_YOUNG_GEN_TUNING =>
      val r = JVM_YOUNG_GEN_TUNING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.ScheduledAutoTuneActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType =
      software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object JVM_HEAP_SIZE_TUNING
      extends zio.aws.elasticsearch.model.ScheduledAutoTuneActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType =
      software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.JVM_HEAP_SIZE_TUNING
  }
  case object JVM_YOUNG_GEN_TUNING
      extends zio.aws.elasticsearch.model.ScheduledAutoTuneActionType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType =
      software.amazon.awssdk.services.elasticsearch.model.ScheduledAutoTuneActionType.JVM_YOUNG_GEN_TUNING
  }
}
