package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointsResponse(
    vpcEndpoints: Iterable[zio.aws.elasticsearch.model.VpcEndpoint],
    vpcEndpointErrors: Iterable[zio.aws.elasticsearch.model.VpcEndpointError]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse = {
    import DescribeVpcEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse
      .builder()
      .vpcEndpoints(vpcEndpoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .vpcEndpointErrors(vpcEndpointErrors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse =
      zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse(
        vpcEndpoints.map { item =>
          item.asEditable
        },
        vpcEndpointErrors.map { item =>
          item.asEditable
        }
      )
    def vpcEndpoints: List[zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly]
    def vpcEndpointErrors
        : List[zio.aws.elasticsearch.model.VpcEndpointError.ReadOnly]
    def getVpcEndpoints: ZIO[Any, Nothing, List[
      zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly
    ]] = ZIO.succeed(vpcEndpoints)
    def getVpcEndpointErrors: ZIO[Any, Nothing, List[
      zio.aws.elasticsearch.model.VpcEndpointError.ReadOnly
    ]] = ZIO.succeed(vpcEndpointErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse
  ) extends zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse.ReadOnly {
    override val vpcEndpoints
        : List[zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly] = impl
      .vpcEndpoints()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.VpcEndpoint.wrap(item)
      }
      .toList
    override val vpcEndpointErrors
        : List[zio.aws.elasticsearch.model.VpcEndpointError.ReadOnly] = impl
      .vpcEndpointErrors()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.VpcEndpointError.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeVpcEndpointsResponse
  ): zio.aws.elasticsearch.model.DescribeVpcEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
