package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedElasticsearchInstancesResponse(
    nextToken: Optional[String] = Optional.Absent,
    reservedElasticsearchInstances: Optional[
      Iterable[zio.aws.elasticsearch.model.ReservedElasticsearchInstance]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse = {
    import DescribeReservedElasticsearchInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        reservedElasticsearchInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedElasticsearchInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
      .wrap(buildAwsValue())
}
object DescribeReservedElasticsearchInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse =
      zio.aws.elasticsearch.model
        .DescribeReservedElasticsearchInstancesResponse(
          nextToken.map(value => value),
          reservedElasticsearchInstances.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def nextToken: Optional[String]
    def reservedElasticsearchInstances: Optional[
      List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReservedElasticsearchInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "reservedElasticsearchInstances",
      reservedElasticsearchInstances
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ) extends zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val reservedElasticsearchInstances: Optional[
      List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedElasticsearchInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.ReservedElasticsearchInstance.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse
  ): zio.aws.elasticsearch.model.DescribeReservedElasticsearchInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
