package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.UpgradeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUpgradeStatusResponse(
    upgradeStep: Optional[zio.aws.elasticsearch.model.UpgradeStep] =
      Optional.Absent,
    stepStatus: Optional[zio.aws.elasticsearch.model.UpgradeStatus] =
      Optional.Absent,
    upgradeName: Optional[UpgradeName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse = {
    import GetUpgradeStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
      .builder()
      .optionallyWith(upgradeStep.map(value => value.unwrap))(_.upgradeStep)
      .optionallyWith(stepStatus.map(value => value.unwrap))(_.stepStatus)
      .optionallyWith(
        upgradeName.map(value => UpgradeName.unwrap(value): java.lang.String)
      )(_.upgradeName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly =
    zio.aws.elasticsearch.model.GetUpgradeStatusResponse.wrap(buildAwsValue())
}
object GetUpgradeStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.GetUpgradeStatusResponse =
      zio.aws.elasticsearch.model.GetUpgradeStatusResponse(
        upgradeStep.map(value => value),
        stepStatus.map(value => value),
        upgradeName.map(value => value)
      )
    def upgradeStep: Optional[zio.aws.elasticsearch.model.UpgradeStep]
    def stepStatus: Optional[zio.aws.elasticsearch.model.UpgradeStatus]
    def upgradeName: Optional[UpgradeName]
    def getUpgradeStep
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStep] =
      AwsError.unwrapOptionField("upgradeStep", upgradeStep)
    def getStepStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.UpgradeStatus] =
      AwsError.unwrapOptionField("stepStatus", stepStatus)
    def getUpgradeName: ZIO[Any, AwsError, UpgradeName] =
      AwsError.unwrapOptionField("upgradeName", upgradeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ) extends zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly {
    override val upgradeStep
        : Optional[zio.aws.elasticsearch.model.UpgradeStep] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeStep())
        .map(value => zio.aws.elasticsearch.model.UpgradeStep.wrap(value))
    override val stepStatus
        : Optional[zio.aws.elasticsearch.model.UpgradeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepStatus())
        .map(value => zio.aws.elasticsearch.model.UpgradeStatus.wrap(value))
    override val upgradeName: Optional[UpgradeName] = zio.aws.core.internal
      .optionalFromNullable(impl.upgradeName())
      .map(value => zio.aws.elasticsearch.model.primitives.UpgradeName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeStatusResponse
  ): zio.aws.elasticsearch.model.GetUpgradeStatusResponse.ReadOnly =
    new Wrapper(impl)
}
