package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpgradeElasticsearchDomainResponse(
    domainName: Optional[DomainName] = Optional.Absent,
    targetVersion: Optional[ElasticsearchVersionString] = Optional.Absent,
    performCheckOnly: Optional[Boolean] = Optional.Absent,
    changeProgressDetails: Optional[
      zio.aws.elasticsearch.model.ChangeProgressDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse = {
    import UpgradeElasticsearchDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(
        targetVersion.map(value =>
          ElasticsearchVersionString.unwrap(value): java.lang.String
        )
      )(_.targetVersion)
      .optionallyWith(performCheckOnly.map(value => value: java.lang.Boolean))(
        _.performCheckOnly
      )
      .optionallyWith(
        changeProgressDetails.map(value => value.buildAwsValue())
      )(_.changeProgressDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse
      .wrap(buildAwsValue())
}
object UpgradeElasticsearchDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse =
      zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse(
        domainName.map(value => value),
        targetVersion.map(value => value),
        performCheckOnly.map(value => value),
        changeProgressDetails.map(value => value.asEditable)
      )
    def domainName: Optional[DomainName]
    def targetVersion: Optional[ElasticsearchVersionString]
    def performCheckOnly: Optional[Boolean]
    def changeProgressDetails
        : Optional[zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getTargetVersion: ZIO[Any, AwsError, ElasticsearchVersionString] =
      AwsError.unwrapOptionField("targetVersion", targetVersion)
    def getPerformCheckOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performCheckOnly", performCheckOnly)
    def getChangeProgressDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly
    ] =
      AwsError.unwrapOptionField("changeProgressDetails", changeProgressDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ) extends zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val targetVersion: Optional[ElasticsearchVersionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetVersion())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .ElasticsearchVersionString(value)
        )
    override val performCheckOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performCheckOnly())
      .map(value => value: Boolean)
    override val changeProgressDetails
        : Optional[zio.aws.elasticsearch.model.ChangeProgressDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeProgressDetails())
        .map(value =>
          zio.aws.elasticsearch.model.ChangeProgressDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainResponse
  ): zio.aws.elasticsearch.model.UpgradeElasticsearchDomainResponse.ReadOnly =
    new Wrapper(impl)
}
