package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListElasticsearchInstanceTypesResponse(
    elasticsearchInstanceTypes: Optional[
      Iterable[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse = {
    import ListElasticsearchInstanceTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse
      .builder()
      .optionallyWith(
        elasticsearchInstanceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.elasticsearchInstanceTypesWithStrings)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse
      .wrap(buildAwsValue())
}
object ListElasticsearchInstanceTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse =
      zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse(
        elasticsearchInstanceTypes.map(value => value),
        nextToken.map(value => value)
      )
    def elasticsearchInstanceTypes
        : Optional[List[zio.aws.elasticsearch.model.ESPartitionInstanceType]]
    def nextToken: Optional[NextToken]
    def getElasticsearchInstanceTypes: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ]] = AwsError.unwrapOptionField(
      "elasticsearchInstanceTypes",
      elasticsearchInstanceTypes
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse
  ) extends zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly {
    override val elasticsearchInstanceTypes
        : Optional[List[zio.aws.elasticsearch.model.ESPartitionInstanceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticsearchInstanceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse
  ): zio.aws.elasticsearch.model.ListElasticsearchInstanceTypesResponse.ReadOnly =
    new Wrapper(impl)
}
