package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CancelElasticsearchServiceSoftwareUpdateResponse(
    serviceSoftwareOptions: Optional[
      zio.aws.elasticsearch.model.ServiceSoftwareOptions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse = {
    import CancelElasticsearchServiceSoftwareUpdateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
      .builder()
      .optionallyWith(
        serviceSoftwareOptions.map(value => value.buildAwsValue())
      )(_.serviceSoftwareOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
      .wrap(buildAwsValue())
}
object CancelElasticsearchServiceSoftwareUpdateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse =
      zio.aws.elasticsearch.model
        .CancelElasticsearchServiceSoftwareUpdateResponse(
          serviceSoftwareOptions.map(value => value.asEditable)
        )
    def serviceSoftwareOptions
        : Optional[zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly]
    def getServiceSoftwareOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSoftwareOptions",
      serviceSoftwareOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ) extends zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly {
    override val serviceSoftwareOptions: Optional[
      zio.aws.elasticsearch.model.ServiceSoftwareOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceSoftwareOptions())
      .map(value =>
        zio.aws.elasticsearch.model.ServiceSoftwareOptions.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse
  ): zio.aws.elasticsearch.model.CancelElasticsearchServiceSoftwareUpdateResponse.ReadOnly =
    new Wrapper(impl)
}
