package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.IntegerClass
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SAMLOptionsOutput(
    enabled: Optional[Boolean] = Optional.Absent,
    idp: Optional[zio.aws.elasticsearch.model.SAMLIdp] = Optional.Absent,
    subjectKey: Optional[String] = Optional.Absent,
    rolesKey: Optional[String] = Optional.Absent,
    sessionTimeoutMinutes: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput = {
    import SAMLOptionsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(idp.map(value => value.buildAwsValue()))(_.idp)
      .optionallyWith(subjectKey.map(value => value: java.lang.String))(
        _.subjectKey
      )
      .optionallyWith(rolesKey.map(value => value: java.lang.String))(
        _.rolesKey
      )
      .optionallyWith(
        sessionTimeoutMinutes.map(value => IntegerClass.unwrap(value): Integer)
      )(_.sessionTimeoutMinutes)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly =
    zio.aws.elasticsearch.model.SAMLOptionsOutput.wrap(buildAwsValue())
}
object SAMLOptionsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SAMLOptionsOutput =
      zio.aws.elasticsearch.model.SAMLOptionsOutput(
        enabled.map(value => value),
        idp.map(value => value.asEditable),
        subjectKey.map(value => value),
        rolesKey.map(value => value),
        sessionTimeoutMinutes.map(value => value)
      )
    def enabled: Optional[Boolean]
    def idp: Optional[zio.aws.elasticsearch.model.SAMLIdp.ReadOnly]
    def subjectKey: Optional[String]
    def rolesKey: Optional[String]
    def sessionTimeoutMinutes: Optional[IntegerClass]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getIdp
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.SAMLIdp.ReadOnly] =
      AwsError.unwrapOptionField("idp", idp)
    def getSubjectKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subjectKey", subjectKey)
    def getRolesKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("rolesKey", rolesKey)
    def getSessionTimeoutMinutes: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField("sessionTimeoutMinutes", sessionTimeoutMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput
  ) extends zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val idp: Optional[zio.aws.elasticsearch.model.SAMLIdp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idp())
        .map(value => zio.aws.elasticsearch.model.SAMLIdp.wrap(value))
    override val subjectKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectKey())
      .map(value => value: String)
    override val rolesKey: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.rolesKey())
      .map(value => value: String)
    override val sessionTimeoutMinutes: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionTimeoutMinutes())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.IntegerClass(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLOptionsOutput
  ): zio.aws.elasticsearch.model.SAMLOptionsOutput.ReadOnly = new Wrapper(impl)
}
