package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus
  ): zio.aws.elasticsearch.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.PENDING_UPDATE =>
      val r = PENDING_UPDATE
      r
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.NOT_ELIGIBLE =>
      val r = NOT_ELIGIBLE
      r
    case software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.ELIGIBLE =>
      val r = ELIGIBLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_UPDATE
      extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.PENDING_UPDATE
  }
  case object IN_PROGRESS extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.IN_PROGRESS
  }
  case object COMPLETED extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.COMPLETED
  }
  case object NOT_ELIGIBLE
      extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.NOT_ELIGIBLE
  }
  case object ELIGIBLE extends zio.aws.elasticsearch.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus =
      software.amazon.awssdk.services.elasticsearch.model.DeploymentStatus.ELIGIBLE
  }
}
