package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetUpgradeHistoryResponse(
    upgradeHistories: Optional[
      Iterable[zio.aws.elasticsearch.model.UpgradeHistory]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse = {
    import GetUpgradeHistoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse
      .builder()
      .optionallyWith(
        upgradeHistories.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.upgradeHistories)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly =
    zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.wrap(buildAwsValue())
}
object GetUpgradeHistoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.GetUpgradeHistoryResponse =
      zio.aws.elasticsearch.model.GetUpgradeHistoryResponse(
        upgradeHistories.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def upgradeHistories
        : Optional[List[zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly]]
    def nextToken: Optional[String]
    def getUpgradeHistories: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly
    ]] = AwsError.unwrapOptionField("upgradeHistories", upgradeHistories)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse
  ) extends zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly {
    override val upgradeHistories
        : Optional[List[zio.aws.elasticsearch.model.UpgradeHistory.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.upgradeHistories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.UpgradeHistory.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse
  ): zio.aws.elasticsearch.model.GetUpgradeHistoryResponse.ReadOnly =
    new Wrapper(impl)
}
