package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  CrossClusterSearchConnectionId,
  ConnectionAlias
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateOutboundCrossClusterSearchConnectionResponse(
    sourceDomainInfo: Optional[zio.aws.elasticsearch.model.DomainInformation] =
      Optional.Absent,
    destinationDomainInfo: Optional[
      zio.aws.elasticsearch.model.DomainInformation
    ] = Optional.Absent,
    connectionAlias: Optional[ConnectionAlias] = Optional.Absent,
    connectionStatus: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
    ] = Optional.Absent,
    crossClusterSearchConnectionId: Optional[CrossClusterSearchConnectionId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse = {
    import CreateOutboundCrossClusterSearchConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse
      .builder()
      .optionallyWith(sourceDomainInfo.map(value => value.buildAwsValue()))(
        _.sourceDomainInfo
      )
      .optionallyWith(
        destinationDomainInfo.map(value => value.buildAwsValue())
      )(_.destinationDomainInfo)
      .optionallyWith(
        connectionAlias.map(value =>
          ConnectionAlias.unwrap(value): java.lang.String
        )
      )(_.connectionAlias)
      .optionallyWith(connectionStatus.map(value => value.buildAwsValue()))(
        _.connectionStatus
      )
      .optionallyWith(
        crossClusterSearchConnectionId.map(value =>
          CrossClusterSearchConnectionId.unwrap(value): java.lang.String
        )
      )(_.crossClusterSearchConnectionId)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly =
    zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse
      .wrap(buildAwsValue())
}
object CreateOutboundCrossClusterSearchConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse =
      zio.aws.elasticsearch.model
        .CreateOutboundCrossClusterSearchConnectionResponse(
          sourceDomainInfo.map(value => value.asEditable),
          destinationDomainInfo.map(value => value.asEditable),
          connectionAlias.map(value => value),
          connectionStatus.map(value => value.asEditable),
          crossClusterSearchConnectionId.map(value => value)
        )
    def sourceDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def destinationDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly]
    def connectionAlias: Optional[ConnectionAlias]
    def connectionStatus: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ]
    def crossClusterSearchConnectionId: Optional[CrossClusterSearchConnectionId]
    def getSourceDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDomainInfo", sourceDomainInfo)
    def getDestinationDomainInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationDomainInfo", destinationDomainInfo)
    def getConnectionAlias: ZIO[Any, AwsError, ConnectionAlias] =
      AwsError.unwrapOptionField("connectionAlias", connectionAlias)
    def getConnectionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getCrossClusterSearchConnectionId
        : ZIO[Any, AwsError, CrossClusterSearchConnectionId] =
      AwsError.unwrapOptionField(
        "crossClusterSearchConnectionId",
        crossClusterSearchConnectionId
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse
  ) extends zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly {
    override val sourceDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDomainInfo())
        .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val destinationDomainInfo
        : Optional[zio.aws.elasticsearch.model.DomainInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationDomainInfo())
        .map(value => zio.aws.elasticsearch.model.DomainInformation.wrap(value))
    override val connectionAlias: Optional[ConnectionAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionAlias())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.ConnectionAlias(value)
        )
    override val connectionStatus: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionStatus())
      .map(value =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
          .wrap(value)
      )
    override val crossClusterSearchConnectionId
        : Optional[CrossClusterSearchConnectionId] = zio.aws.core.internal
      .optionalFromNullable(impl.crossClusterSearchConnectionId())
      .map(value =>
        zio.aws.elasticsearch.model.primitives
          .CrossClusterSearchConnectionId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse
  ): zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
