package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  ReferencePath,
  PackageName,
  DomainName,
  PackageVersion,
  LastUpdated,
  PackageID
}
import scala.jdk.CollectionConverters._
final case class DomainPackageDetails(
    packageID: Optional[PackageID] = Optional.Absent,
    packageName: Optional[PackageName] = Optional.Absent,
    packageType: Optional[zio.aws.elasticsearch.model.PackageType] =
      Optional.Absent,
    lastUpdated: Optional[LastUpdated] = Optional.Absent,
    domainName: Optional[DomainName] = Optional.Absent,
    domainPackageStatus: Optional[
      zio.aws.elasticsearch.model.DomainPackageStatus
    ] = Optional.Absent,
    packageVersion: Optional[PackageVersion] = Optional.Absent,
    referencePath: Optional[ReferencePath] = Optional.Absent,
    errorDetails: Optional[zio.aws.elasticsearch.model.ErrorDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails = {
    import DomainPackageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
      .builder()
      .optionallyWith(
        packageID.map(value => PackageID.unwrap(value): java.lang.String)
      )(_.packageID)
      .optionallyWith(
        packageName.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(
        lastUpdated.map(value => LastUpdated.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(domainPackageStatus.map(value => value.unwrap))(
        _.domainPackageStatus
      )
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        referencePath.map(value =>
          ReferencePath.unwrap(value): java.lang.String
        )
      )(_.referencePath)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly =
    zio.aws.elasticsearch.model.DomainPackageDetails.wrap(buildAwsValue())
}
object DomainPackageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainPackageDetails =
      zio.aws.elasticsearch.model.DomainPackageDetails(
        packageID.map(value => value),
        packageName.map(value => value),
        packageType.map(value => value),
        lastUpdated.map(value => value),
        domainName.map(value => value),
        domainPackageStatus.map(value => value),
        packageVersion.map(value => value),
        referencePath.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def packageID: Optional[PackageID]
    def packageName: Optional[PackageName]
    def packageType: Optional[zio.aws.elasticsearch.model.PackageType]
    def lastUpdated: Optional[LastUpdated]
    def domainName: Optional[DomainName]
    def domainPackageStatus
        : Optional[zio.aws.elasticsearch.model.DomainPackageStatus]
    def packageVersion: Optional[PackageVersion]
    def referencePath: Optional[ReferencePath]
    def errorDetails
        : Optional[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly]
    def getPackageID: ZIO[Any, AwsError, PackageID] =
      AwsError.unwrapOptionField("packageID", packageID)
    def getPackageName: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackageType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getLastUpdated: ZIO[Any, AwsError, LastUpdated] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainPackageStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.DomainPackageStatus] =
      AwsError.unwrapOptionField("domainPackageStatus", domainPackageStatus)
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getReferencePath: ZIO[Any, AwsError, ReferencePath] =
      AwsError.unwrapOptionField("referencePath", referencePath)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ) extends zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly {
    override val packageID: Optional[PackageID] = zio.aws.core.internal
      .optionalFromNullable(impl.packageID())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageID(value))
    override val packageName: Optional[PackageName] = zio.aws.core.internal
      .optionalFromNullable(impl.packageName())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageName(value))
    override val packageType
        : Optional[zio.aws.elasticsearch.model.PackageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageType())
        .map(value => zio.aws.elasticsearch.model.PackageType.wrap(value))
    override val lastUpdated: Optional[LastUpdated] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.elasticsearch.model.primitives.LastUpdated(value))
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val domainPackageStatus
        : Optional[zio.aws.elasticsearch.model.DomainPackageStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainPackageStatus())
        .map(value =>
          zio.aws.elasticsearch.model.DomainPackageStatus.wrap(value)
        )
    override val packageVersion: Optional[PackageVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageVersion())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.PackageVersion(value)
        )
    override val referencePath: Optional[ReferencePath] = zio.aws.core.internal
      .optionalFromNullable(impl.referencePath())
      .map(value => zio.aws.elasticsearch.model.primitives.ReferencePath(value))
    override val errorDetails
        : Optional[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorDetails())
        .map(value => zio.aws.elasticsearch.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ): zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly = new Wrapper(
    impl
  )
}
