package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  DryRun,
  PolicyDocument,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateElasticsearchDomainConfigRequest(
    domainName: DomainName,
    elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig
    ] = Optional.Absent,
    ebsOptions: Optional[zio.aws.elasticsearch.model.EBSOptions] =
      Optional.Absent,
    snapshotOptions: Optional[zio.aws.elasticsearch.model.SnapshotOptions] =
      Optional.Absent,
    vpcOptions: Optional[zio.aws.elasticsearch.model.VPCOptions] =
      Optional.Absent,
    cognitoOptions: Optional[zio.aws.elasticsearch.model.CognitoOptions] =
      Optional.Absent,
    advancedOptions: Optional[Map[String, String]] = Optional.Absent,
    accessPolicies: Optional[PolicyDocument] = Optional.Absent,
    logPublishingOptions: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption
    ]] = Optional.Absent,
    domainEndpointOptions: Optional[
      zio.aws.elasticsearch.model.DomainEndpointOptions
    ] = Optional.Absent,
    advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput
    ] = Optional.Absent,
    nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
    ] = Optional.Absent,
    encryptionAtRestOptions: Optional[
      zio.aws.elasticsearch.model.EncryptionAtRestOptions
    ] = Optional.Absent,
    autoTuneOptions: Optional[zio.aws.elasticsearch.model.AutoTuneOptions] =
      Optional.Absent,
    dryRun: Optional[DryRun] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest = {
    import UpdateElasticsearchDomainConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        elasticsearchClusterConfig.map(value => value.buildAwsValue())
      )(_.elasticsearchClusterConfig)
      .optionallyWith(ebsOptions.map(value => value.buildAwsValue()))(
        _.ebsOptions
      )
      .optionallyWith(snapshotOptions.map(value => value.buildAwsValue()))(
        _.snapshotOptions
      )
      .optionallyWith(vpcOptions.map(value => value.buildAwsValue()))(
        _.vpcOptions
      )
      .optionallyWith(cognitoOptions.map(value => value.buildAwsValue()))(
        _.cognitoOptions
      )
      .optionallyWith(
        advancedOptions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.advancedOptions)
      .optionallyWith(
        accessPolicies.map(value =>
          PolicyDocument.unwrap(value): java.lang.String
        )
      )(_.accessPolicies)
      .optionallyWith(
        logPublishingOptions.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.logPublishingOptionsWithStrings)
      .optionallyWith(
        domainEndpointOptions.map(value => value.buildAwsValue())
      )(_.domainEndpointOptions)
      .optionallyWith(
        advancedSecurityOptions.map(value => value.buildAwsValue())
      )(_.advancedSecurityOptions)
      .optionallyWith(
        nodeToNodeEncryptionOptions.map(value => value.buildAwsValue())
      )(_.nodeToNodeEncryptionOptions)
      .optionallyWith(
        encryptionAtRestOptions.map(value => value.buildAwsValue())
      )(_.encryptionAtRestOptions)
      .optionallyWith(autoTuneOptions.map(value => value.buildAwsValue()))(
        _.autoTuneOptions
      )
      .optionallyWith(
        dryRun.map(value => DryRun.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly =
    zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
      .wrap(buildAwsValue())
}
object UpdateElasticsearchDomainConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest =
      zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest(
        domainName,
        elasticsearchClusterConfig.map(value => value.asEditable),
        ebsOptions.map(value => value.asEditable),
        snapshotOptions.map(value => value.asEditable),
        vpcOptions.map(value => value.asEditable),
        cognitoOptions.map(value => value.asEditable),
        advancedOptions.map(value => value),
        accessPolicies.map(value => value),
        logPublishingOptions.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        domainEndpointOptions.map(value => value.asEditable),
        advancedSecurityOptions.map(value => value.asEditable),
        nodeToNodeEncryptionOptions.map(value => value.asEditable),
        encryptionAtRestOptions.map(value => value.asEditable),
        autoTuneOptions.map(value => value.asEditable),
        dryRun.map(value => value)
      )
    def domainName: DomainName
    def elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ]
    def ebsOptions: Optional[zio.aws.elasticsearch.model.EBSOptions.ReadOnly]
    def snapshotOptions
        : Optional[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly]
    def vpcOptions: Optional[zio.aws.elasticsearch.model.VPCOptions.ReadOnly]
    def cognitoOptions
        : Optional[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly]
    def advancedOptions: Optional[Map[String, String]]
    def accessPolicies: Optional[PolicyDocument]
    def logPublishingOptions: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]]
    def domainEndpointOptions
        : Optional[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly]
    def advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ]
    def nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ]
    def encryptionAtRestOptions
        : Optional[zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly]
    def autoTuneOptions
        : Optional[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly]
    def dryRun: Optional[DryRun]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getElasticsearchClusterConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "elasticsearchClusterConfig",
      elasticsearchClusterConfig
    )
    def getEbsOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptions", ebsOptions)
    def getSnapshotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly
    ] = AwsError.unwrapOptionField("snapshotOptions", snapshotOptions)
    def getVpcOptions
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      AwsError.unwrapOptionField("vpcOptions", vpcOptions)
    def getCognitoOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    ] = AwsError.unwrapOptionField("cognitoOptions", cognitoOptions)
    def getAdvancedOptions: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("advancedOptions", advancedOptions)
    def getAccessPolicies: ZIO[Any, AwsError, PolicyDocument] =
      AwsError.unwrapOptionField("accessPolicies", accessPolicies)
    def getLogPublishingOptions: ZIO[Any, AwsError, Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] =
      AwsError.unwrapOptionField("logPublishingOptions", logPublishingOptions)
    def getDomainEndpointOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly
    ] =
      AwsError.unwrapOptionField("domainEndpointOptions", domainEndpointOptions)
    def getAdvancedSecurityOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "advancedSecurityOptions",
      advancedSecurityOptions
    )
    def getNodeToNodeEncryptionOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "nodeToNodeEncryptionOptions",
      nodeToNodeEncryptionOptions
    )
    def getEncryptionAtRestOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionAtRestOptions",
      encryptionAtRestOptions
    )
    def getAutoTuneOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("autoTuneOptions", autoTuneOptions)
    def getDryRun: ZIO[Any, AwsError, DryRun] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ) extends zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val elasticsearchClusterConfig: Optional[
      zio.aws.elasticsearch.model.ElasticsearchClusterConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.elasticsearchClusterConfig())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchClusterConfig.wrap(value)
      )
    override val ebsOptions
        : Optional[zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptions())
        .map(value => zio.aws.elasticsearch.model.EBSOptions.wrap(value))
    override val snapshotOptions
        : Optional[zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotOptions())
        .map(value => zio.aws.elasticsearch.model.SnapshotOptions.wrap(value))
    override val vpcOptions
        : Optional[zio.aws.elasticsearch.model.VPCOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcOptions())
        .map(value => zio.aws.elasticsearch.model.VPCOptions.wrap(value))
    override val cognitoOptions
        : Optional[zio.aws.elasticsearch.model.CognitoOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoOptions())
        .map(value => zio.aws.elasticsearch.model.CognitoOptions.wrap(value))
    override val advancedOptions: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.advancedOptions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val accessPolicies: Optional[PolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessPolicies())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.PolicyDocument(value)
        )
    override val logPublishingOptions: Optional[Map[
      zio.aws.elasticsearch.model.LogType,
      zio.aws.elasticsearch.model.LogPublishingOption.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.logPublishingOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elasticsearch.model.LogType.wrap(
              key
            ) -> zio.aws.elasticsearch.model.LogPublishingOption.wrap(value)
          })
          .toMap
      )
    override val domainEndpointOptions
        : Optional[zio.aws.elasticsearch.model.DomainEndpointOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainEndpointOptions())
        .map(value =>
          zio.aws.elasticsearch.model.DomainEndpointOptions.wrap(value)
        )
    override val advancedSecurityOptions: Optional[
      zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.advancedSecurityOptions())
      .map(value =>
        zio.aws.elasticsearch.model.AdvancedSecurityOptionsInput.wrap(value)
      )
    override val nodeToNodeEncryptionOptions: Optional[
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeToNodeEncryptionOptions())
      .map(value =>
        zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.wrap(value)
      )
    override val encryptionAtRestOptions: Optional[
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionAtRestOptions())
      .map(value =>
        zio.aws.elasticsearch.model.EncryptionAtRestOptions.wrap(value)
      )
    override val autoTuneOptions
        : Optional[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTuneOptions())
        .map(value => zio.aws.elasticsearch.model.AutoTuneOptions.wrap(value))
    override val dryRun: Optional[DryRun] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => zio.aws.elasticsearch.model.primitives.DryRun(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest
  ): zio.aws.elasticsearch.model.UpdateElasticsearchDomainConfigRequest.ReadOnly =
    new Wrapper(impl)
}
