package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpgradeElasticsearchDomainRequest(
    domainName: DomainName,
    targetVersion: ElasticsearchVersionString,
    performCheckOnly: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest = {
    import UpgradeElasticsearchDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .targetVersion(
        ElasticsearchVersionString.unwrap(targetVersion): java.lang.String
      )
      .optionallyWith(performCheckOnly.map(value => value: java.lang.Boolean))(
        _.performCheckOnly
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest.ReadOnly =
    zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest
      .wrap(buildAwsValue())
}
object UpgradeElasticsearchDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest =
      zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest(
        domainName,
        targetVersion,
        performCheckOnly.map(value => value)
      )
    def domainName: DomainName
    def targetVersion: ElasticsearchVersionString
    def performCheckOnly: Optional[Boolean]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getTargetVersion: ZIO[Any, Nothing, ElasticsearchVersionString] =
      ZIO.succeed(targetVersion)
    def getPerformCheckOnly: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("performCheckOnly", performCheckOnly)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest
  ) extends zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val targetVersion: ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives
        .ElasticsearchVersionString(impl.targetVersion())
    override val performCheckOnly: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.performCheckOnly())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpgradeElasticsearchDomainRequest
  ): zio.aws.elasticsearch.model.UpgradeElasticsearchDomainRequest.ReadOnly =
    new Wrapper(impl)
}
