package zio.aws.elasticsearch.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.StartAt
import scala.jdk.CollectionConverters._
final case class AutoTuneMaintenanceSchedule(
    startAt: Optional[StartAt] = Optional.Absent,
    duration: Optional[zio.aws.elasticsearch.model.Duration] = Optional.Absent,
    cronExpressionForRecurrence: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule = {
    import AutoTuneMaintenanceSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
      .builder()
      .optionallyWith(startAt.map(value => StartAt.unwrap(value): Instant))(
        _.startAt
      )
      .optionallyWith(duration.map(value => value.buildAwsValue()))(_.duration)
      .optionallyWith(
        cronExpressionForRecurrence.map(value => value: java.lang.String)
      )(_.cronExpressionForRecurrence)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule
      .wrap(buildAwsValue())
}
object AutoTuneMaintenanceSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule =
      zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule(
        startAt.map(value => value),
        duration.map(value => value.asEditable),
        cronExpressionForRecurrence.map(value => value)
      )
    def startAt: Optional[StartAt]
    def duration: Optional[zio.aws.elasticsearch.model.Duration.ReadOnly]
    def cronExpressionForRecurrence: Optional[String]
    def getStartAt: ZIO[Any, AwsError, StartAt] =
      AwsError.unwrapOptionField("startAt", startAt)
    def getDuration
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.Duration.ReadOnly] =
      AwsError.unwrapOptionField("duration", duration)
    def getCronExpressionForRecurrence: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "cronExpressionForRecurrence",
        cronExpressionForRecurrence
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ) extends zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly {
    override val startAt: Optional[StartAt] = zio.aws.core.internal
      .optionalFromNullable(impl.startAt())
      .map(value => zio.aws.elasticsearch.model.primitives.StartAt(value))
    override val duration
        : Optional[zio.aws.elasticsearch.model.Duration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.duration())
        .map(value => zio.aws.elasticsearch.model.Duration.wrap(value))
    override val cronExpressionForRecurrence: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpressionForRecurrence())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneMaintenanceSchedule
  ): zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly =
    new Wrapper(impl)
}
