package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EBSOptionsStatus(
    options: zio.aws.elasticsearch.model.EBSOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus = {
    import EBSOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.EBSOptionsStatus.wrap(buildAwsValue())
}
object EBSOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.EBSOptionsStatus =
      zio.aws.elasticsearch.model
        .EBSOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.EBSOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.EBSOptions.ReadOnly] =
      ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus
  ) extends zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly {
    override val options: zio.aws.elasticsearch.model.EBSOptions.ReadOnly =
      zio.aws.elasticsearch.model.EBSOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.EBSOptionsStatus
  ): zio.aws.elasticsearch.model.EBSOptionsStatus.ReadOnly = new Wrapper(impl)
}
