package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteElasticsearchDomainResponse(
    domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse = {
    import DeleteElasticsearchDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse
      .builder()
      .optionallyWith(domainStatus.map(value => value.buildAwsValue()))(
        _.domainStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly =
    zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse
      .wrap(buildAwsValue())
}
object DeleteElasticsearchDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse =
      zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse(
        domainStatus.map(value => value.asEditable)
      )
    def domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ]
    def getDomainStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ] = AwsError.unwrapOptionField("domainStatus", domainStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse
  ) extends zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly {
    override val domainStatus: Optional[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.domainStatus())
      .map(value =>
        zio.aws.elasticsearch.model.ElasticsearchDomainStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteElasticsearchDomainResponse
  ): zio.aws.elasticsearch.model.DeleteElasticsearchDomainResponse.ReadOnly =
    new Wrapper(impl)
}
