package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartElasticsearchServiceSoftwareUpdateRequest(
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest = {
    import StartElasticsearchServiceSoftwareUpdateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest.ReadOnly =
    zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest
      .wrap(buildAwsValue())
}
object StartElasticsearchServiceSoftwareUpdateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest =
      zio.aws.elasticsearch.model
        .StartElasticsearchServiceSoftwareUpdateRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest
  ) extends zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest
  ): zio.aws.elasticsearch.model.StartElasticsearchServiceSoftwareUpdateRequest.ReadOnly =
    new Wrapper(impl)
}
