package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionStatusMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OutboundCrossClusterSearchConnectionStatus(
    statusCode: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = Optional.Absent,
    message: Optional[CrossClusterSearchConnectionStatusMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus = {
    import OutboundCrossClusterSearchConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        message.map(value =>
          CrossClusterSearchConnectionStatusMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly =
    zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
      .wrap(buildAwsValue())
}
object OutboundCrossClusterSearchConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus =
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ]
    def message: Optional[CrossClusterSearchConnectionStatusMessage]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage
        : ZIO[Any, AwsError, CrossClusterSearchConnectionStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ) extends zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly {
    override val statusCode: Optional[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusCode())
      .map(value =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
          .wrap(value)
      )
    override val message: Optional[CrossClusterSearchConnectionStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.message())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .CrossClusterSearchConnectionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ): zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly =
    new Wrapper(impl)
}
